/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.walkers;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.log4j.Logger;
import org.walkmod.ChainWalker;
import org.walkmod.Resource;
import org.walkmod.conf.entities.ChainConfig;
import org.walkmod.conf.entities.TransformationConfig;
import org.walkmod.exceptions.WalkModException;
import org.walkmod.merger.IdentificableNode;
import org.walkmod.merger.MergeEngine;
import org.walkmod.merger.Mergeable;
import org.walkmod.walkers.VisitorContext;
import org.walkmod.walkers.VisitorMessage;

public abstract class AbstractWalker
implements ChainWalker {
    public static final String NAMESPACE_SEPARATOR = "::";
    private List<Object> visitor;
    private Object writer;
    private Resource<?> resource;
    private String rootNamespace;
    private ChainConfig chainConfig;
    private Set<Object> visitedElements = new HashSet<Object>();
    private Collection<VisitorMessage> visitorMessages = new LinkedList<VisitorMessage>();
    private static Logger log = Logger.getLogger(AbstractWalker.class);
    public static final String ORIGINAL_FILE_KEY = "original_file_key";

    @Override
    public void setVisitors(List<Object> visitor) {
        this.visitor = visitor;
    }

    protected void visit(Object element, List<Object> visitors, List<TransformationConfig> transformations, VisitorContext context) throws Exception {
        String qualifiedName;
        if (this.rootNamespace != null && !"".equals(this.rootNamespace) && this.rootNamespace.startsWith(qualifiedName = this.getResource().getNearestNamespace(element, NAMESPACE_SEPARATOR))) {
            return;
        }
        int index = 0;
        for (Object visitor : visitors) {
            boolean isMergeable = transformations.get(index).isMergeable();
            String mergePolicy = transformations.get(index).getMergePolicy();
            if (mergePolicy != null) {
                isMergeable = true;
            }
            if (isMergeable && mergePolicy == null) {
                mergePolicy = "default";
            }
            Method[] methods = visitor.getClass().getMethods();
            List<Object> restVisitors = visitors.subList(index + 1, visitors.size());
            List<TransformationConfig> restTransformations = transformations.subList(index + 1, transformations.size());
            HashSet<String> visitedTypes = new HashSet<String>();
            for (int j = 0; j < methods.length; ++j) {
                if (!methods[j].getName().equals("visit")) continue;
                Class<?> type = methods[j].getParameterTypes()[0];
                if (visitedTypes.contains(element.getClass().getName()) || !type.isInstance(element)) continue;
                visitedTypes.add(type.getName());
                int paramsLength = methods[j].getParameterTypes().length;
                Object[] params = new Object[paramsLength];
                params[0] = element;
                VisitorContext args = new VisitorContext(this.getChainConfig());
                args.putAll(context);
                if (paramsLength == 2) {
                    params[1] = args;
                }
                methods[j].invoke(visitor, params);
                context.getVisitorMessages().addAll(args.getVisitorMessages());
                MergeEngine me = null;
                if (isMergeable) {
                    me = this.chainConfig.getConfiguration().getMergeEngine(mergePolicy);
                }
                if (args.hasResultNodes()) {
                    Iterator<Object> it = args.getResultNodes().iterator();
                    if (!it.hasNext()) continue;
                    Object currentArg = it.next();
                    if (isMergeable) {
                        currentArg = this.merge(currentArg, me, context);
                    }
                    context.addResultNode(currentArg);
                    this.visit(currentArg, restVisitors, restTransformations, context);
                    return;
                }
                context.addResultNode(element);
            }
            ++index;
        }
    }

    protected abstract Object getSourceNode(Object var1);

    protected void visit(Object element) throws Exception {
        VisitorContext context = new VisitorContext(this.getChainConfig());
        this.visit(element, context);
        this.addVisitorMessages(context);
    }

    protected void visit(Object element, VisitorContext vc) throws Exception {
        List<TransformationConfig> colTransformations = this.getChainConfig().getWalkerConfig().getTransformations();
        List<TransformationConfig> transformations = colTransformations instanceof List ? this.getChainConfig().getWalkerConfig().getTransformations() : new LinkedList<TransformationConfig>(colTransformations);
        this.visit(element, this.getVisitors(), transformations, vc);
        if (vc.getResultNodes() != null) {
            this.writeAll(vc.getResultNodes());
        }
    }

    protected void writeAll(Collection<Object> elements) throws Exception {
        if (elements != null) {
            Iterator<Object> it = elements.iterator();
            while (it.hasNext()) {
                this.write(it.next());
            }
        }
    }

    protected void write(Object element) throws Exception {
        this.write(element, null);
    }

    protected void write(Object element, VisitorContext vc) throws Exception {
        Method[] methods = this.writer.getClass().getMethods();
        for (int j = 0; j < methods.length; ++j) {
            if (!methods[j].getName().equals("write")) continue;
            Class<?> type = methods[j].getParameterTypes()[0];
            int paramsLength = methods[j].getParameterTypes().length;
            Object[] params = new Object[paramsLength];
            params[0] = element;
            if (paramsLength == 2) {
                params[1] = vc;
            }
            if (!type.isInstance(element)) continue;
            methods[j].invoke(this.writer, params);
        }
    }

    public boolean isVisitable(Object element) throws Exception {
        String qualifiedName;
        if (this.rootNamespace != null && !"".equals(this.rootNamespace) && !(qualifiedName = this.getResource().getNearestNamespace(element, NAMESPACE_SEPARATOR)).startsWith(this.rootNamespace)) {
            return false;
        }
        return this.visitedElements.add(element);
    }

    @Override
    public List<Object> getVisitors() {
        return this.visitor;
    }

    @Override
    public void setResource(Resource<?> resource) {
        this.resource = resource;
    }

    public Resource<?> getResource() {
        return this.resource;
    }

    public Set<Object> getVisitedElements() {
        return this.visitedElements;
    }

    public void setVisitedElements(Set<Object> visitedElements) {
        this.visitedElements = visitedElements;
    }

    @Override
    public void setRootNamespace(String namespace) {
        this.rootNamespace = namespace;
    }

    @Override
    public String getRootNamespace() {
        return this.rootNamespace;
    }

    public void walk(Object element) throws Exception {
        if (element != null) {
            LinkedList types = new LinkedList();
            types.add(element.getClass());
            ConcurrentLinkedQueue interfaces = new ConcurrentLinkedQueue(types);
            LinkedList<Class> visitedTypes = new LinkedList<Class>();
            while (interfaces.size() > 0) {
                Class type = (Class)interfaces.poll();
                if (!visitedTypes.add(type)) continue;
                try {
                    Method m = this.getClass().getMethod("accept", type);
                    m.invoke((Object)this, element);
                    interfaces.addAll(Arrays.asList(type.getInterfaces()));
                }
                catch (NoSuchMethodException e) {}
            }
        }
    }

    @Override
    public void execute() throws Exception {
        for (Object current : this.getResource()) {
            try {
                this.walk(current);
            }
            catch (WalkModException e) {
                log.error((Object)e.getMessage());
            }
        }
    }

    @Override
    public void setWriter(Object writer) {
        this.writer = writer;
    }

    @Override
    public Object getWriter() {
        return this.writer;
    }

    public ChainConfig getChainConfig() {
        return this.chainConfig;
    }

    @Override
    public void setChainConfig(ChainConfig chainConfig) {
        this.chainConfig = chainConfig;
    }

    @Override
    public Collection<VisitorMessage> getVisitorMessages() {
        return this.visitorMessages;
    }

    protected void addVisitorMessages(VisitorContext ctx) {
        Collection<String> messages = ctx.getVisitorMessages();
        String location = this.getLocation(ctx);
        for (String message : messages) {
            VisitorMessage m = new VisitorMessage(location, message);
            this.visitorMessages.add(m);
        }
    }

    protected abstract String getLocation(VisitorContext var1);

    protected Object merge(Object object, MergeEngine mergeEngine, VisitorContext vc) {
        Object local = null;
        Collection<Object> rnodes = vc.getResultNodes();
        boolean previousResult = false;
        Iterator<Object> it = rnodes.iterator();
        if (object instanceof IdentificableNode) {
            local = null;
            Comparator cmp = ((IdentificableNode)object).getIdentityComparator();
            boolean deleted = false;
            while (it.hasNext() && local == null) {
                Object current = it.next();
                if (current == object) {
                    it.remove();
                    deleted = true;
                    continue;
                }
                if (!object.getClass().equals(current.getClass()) || cmp.compare(current, object) != 0) continue;
                if (deleted) {
                    local = object;
                    object = current;
                    continue;
                }
                local = current;
            }
        } else {
            it = rnodes.iterator();
            while (it.hasNext() && local == null) {
                Object current = it.next();
                if (current == object) {
                    it.remove();
                    continue;
                }
                if (!current.equals(object)) continue;
                local = current;
            }
        }
        boolean bl = previousResult = local != null;
        if (!previousResult) {
            local = this.getSourceNode(object);
        }
        if (local != null) {
            if (object instanceof Mergeable) {
                ((Mergeable)local).merge(object, mergeEngine);
                if (previousResult) {
                    it.remove();
                }
                return local;
            }
            if (previousResult) {
                it.remove();
            }
            return object;
        }
        if (previousResult) {
            it.remove();
        }
        return local;
    }

    @Override
    public boolean hasChanges() {
        return this.getNumModifications() != 0 || this.getNumAdditions() != 0 || this.getNumDeletions() != 0;
    }
}

