/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.util.location;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.walkmod.util.location.Location;

public class LocationImpl
implements Location {
    private final String description;
    private final String URI;
    private final int lineNumber;
    private final int columnNumber;
    public static final LocationImpl UNKNOWN = new LocationImpl(null, null, -1, -1);

    public LocationImpl(String description, String uri) {
        this(description, uri, -1, -1);
    }

    public LocationImpl(String description, String uri, int line, int column) {
        if (uri == null || uri.length() == 0) {
            this.URI = null;
            this.lineNumber = -1;
            this.columnNumber = -1;
        } else {
            this.URI = uri;
            this.lineNumber = line;
            this.columnNumber = column;
        }
        if (description != null && description.length() == 0) {
            description = null;
        }
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getURI() {
        return this.URI;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int getColumnNumber() {
        return this.columnNumber;
    }

    @Override
    public List<String> getSnippet(int padding) {
        ArrayList<String> snippet = new ArrayList<String>();
        if (this.getLineNumber() > 0) {
            try {
                String line;
                InputStream in = new URL(this.getURI()).openStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                int lineno = 0;
                int errno = this.getLineNumber();
                while ((line = reader.readLine()) != null) {
                    if (++lineno < errno - padding || lineno > errno + padding) continue;
                    snippet.add(line);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return snippet;
    }
}

