/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.util;

import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.walkmod.exceptions.WalkModException;
import org.walkmod.util.ClassLoaderUtil;
import org.walkmod.util.location.Location;
import org.walkmod.util.location.LocationAttributes;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class DomHelper {
    private static final Log LOG = LogFactory.getLog(DomHelper.class);
    public static final String XMLNS_URI = "http://www.w3.org/2000/xmlns/";

    public static Location getLocationObject(Element element) {
        return LocationAttributes.getLocation(element);
    }

    public static Document parse(InputSource inputSource) {
        return DomHelper.parse(inputSource, null);
    }

    public static Document parse(InputSource inputSource, Map<String, String> dtdMappings) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(dtdMappings != null);
        factory.setNamespaceAware(true);
        SAXParser parser = null;
        try {
            parser = factory.newSAXParser();
        }
        catch (Exception ex) {
            throw new WalkModException("Unable to create SAX parser", ex);
        }
        DOMBuilder builder = new DOMBuilder();
        LocationAttributes.Pipe locationHandler = new LocationAttributes.Pipe(builder);
        try {
            parser.parse(inputSource, (DefaultHandler)new StartHandler(locationHandler, dtdMappings));
        }
        catch (Exception ex) {
            throw new WalkModException(ex);
        }
        return builder.getDocument();
    }

    public static class StartHandler
    extends DefaultHandler {
        private ContentHandler nextHandler;
        private Map<String, String> dtdMappings;

        public StartHandler(ContentHandler next, Map<String, String> dtdMappings) {
            this.nextHandler = next;
            this.dtdMappings = dtdMappings;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.nextHandler.setDocumentLocator(locator);
        }

        @Override
        public void startDocument() throws SAXException {
            this.nextHandler.startDocument();
        }

        @Override
        public void endDocument() throws SAXException {
            this.nextHandler.endDocument();
        }

        @Override
        public void startElement(String uri, String loc, String raw, Attributes attrs) throws SAXException {
            this.nextHandler.startElement(uri, loc, raw, attrs);
        }

        @Override
        public void endElement(String arg0, String arg1, String arg2) throws SAXException {
            this.nextHandler.endElement(arg0, arg1, arg2);
        }

        @Override
        public void startPrefixMapping(String arg0, String arg1) throws SAXException {
            this.nextHandler.startPrefixMapping(arg0, arg1);
        }

        @Override
        public void endPrefixMapping(String arg0) throws SAXException {
            this.nextHandler.endPrefixMapping(arg0);
        }

        @Override
        public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
            this.nextHandler.characters(arg0, arg1, arg2);
        }

        @Override
        public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
            this.nextHandler.ignorableWhitespace(arg0, arg1, arg2);
        }

        @Override
        public void processingInstruction(String arg0, String arg1) throws SAXException {
            this.nextHandler.processingInstruction(arg0, arg1);
        }

        @Override
        public void skippedEntity(String arg0) throws SAXException {
            this.nextHandler.skippedEntity(arg0);
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            if (this.dtdMappings != null && this.dtdMappings.containsKey(publicId)) {
                String val = this.dtdMappings.get(publicId).toString();
                return new InputSource(ClassLoaderUtil.getResourceAsStream(val, DomHelper.class));
            }
            return null;
        }

        @Override
        public void warning(SAXParseException exception) {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            LOG.error((Object)(exception.getMessage() + " at (" + exception.getPublicId() + ":" + exception.getLineNumber() + ":" + exception.getColumnNumber() + ")"), (Throwable)exception);
            throw exception;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            LOG.fatal((Object)(exception.getMessage() + " at (" + exception.getPublicId() + ":" + exception.getLineNumber() + ":" + exception.getColumnNumber() + ")"), (Throwable)exception);
            throw exception;
        }
    }

    public static class DOMBuilder
    implements ContentHandler {
        protected static SAXTransformerFactory FACTORY = (SAXTransformerFactory)TransformerFactory.newInstance();
        protected SAXTransformerFactory factory;
        protected DOMResult result;
        protected Node parentNode;
        protected ContentHandler nextHandler;

        public DOMBuilder() {
            this((Node)null);
        }

        public DOMBuilder(SAXTransformerFactory factory) {
            this(factory, null);
        }

        public DOMBuilder(Node parentNode) {
            this(null, parentNode);
        }

        public DOMBuilder(SAXTransformerFactory factory, Node parentNode) {
            this.factory = factory == null ? FACTORY : factory;
            this.parentNode = parentNode;
            this.setup();
        }

        private void setup() {
            try {
                TransformerHandler handler = this.factory.newTransformerHandler();
                this.nextHandler = handler;
                this.result = this.parentNode != null ? new DOMResult(this.parentNode) : new DOMResult();
                handler.setResult(this.result);
            }
            catch (TransformerException local) {
                throw new WalkModException("Fatal-Error: Unable to get transformer handler", local);
            }
        }

        public Document getDocument() {
            if (this.result == null || this.result.getNode() == null) {
                return null;
            }
            if (this.result.getNode().getNodeType() == 9) {
                return (Document)this.result.getNode();
            }
            return this.result.getNode().getOwnerDocument();
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.nextHandler.setDocumentLocator(locator);
        }

        @Override
        public void startDocument() throws SAXException {
            this.nextHandler.startDocument();
        }

        @Override
        public void endDocument() throws SAXException {
            this.nextHandler.endDocument();
        }

        @Override
        public void startElement(String uri, String loc, String raw, Attributes attrs) throws SAXException {
            this.nextHandler.startElement(uri, loc, raw, attrs);
        }

        @Override
        public void endElement(String arg0, String arg1, String arg2) throws SAXException {
            this.nextHandler.endElement(arg0, arg1, arg2);
        }

        @Override
        public void startPrefixMapping(String arg0, String arg1) throws SAXException {
            this.nextHandler.startPrefixMapping(arg0, arg1);
        }

        @Override
        public void endPrefixMapping(String arg0) throws SAXException {
            this.nextHandler.endPrefixMapping(arg0);
        }

        @Override
        public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
            this.nextHandler.characters(arg0, arg1, arg2);
        }

        @Override
        public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
            this.nextHandler.ignorableWhitespace(arg0, arg1, arg2);
        }

        @Override
        public void processingInstruction(String arg0, String arg1) throws SAXException {
            this.nextHandler.processingInstruction(arg0, arg1);
        }

        @Override
        public void skippedEntity(String arg0) throws SAXException {
            this.nextHandler.skippedEntity(arg0);
        }
    }
}

