/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.query;

import groovy.lang.GroovyClassLoader;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.log4j.Logger;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.jsr223.GroovyScriptEngineImpl;
import org.walkmod.exceptions.WalkModException;
import org.walkmod.query.QueryEngine;
import org.walkmod.scripting.ScriptProcessor;
import org.walkmod.walkers.VisitorContext;

public class ScriptingQueryEngine
implements QueryEngine {
    private String language = "groovy";
    private ScriptEngine engine = null;
    private VisitorContext context = null;
    private static Logger log = Logger.getLogger(ScriptProcessor.class);
    private Bindings bindings;
    private Object rootNode = null;
    private List<String> includes;

    @Override
    public void initialize(VisitorContext context) {
        this.initialize(context, Collections.EMPTY_MAP);
    }

    @Override
    public void initialize(VisitorContext context, Map<String, Object> parameters) {
        if (this.engine == null) {
            ScriptEngineManager factory = new ScriptEngineManager(context.getClassLoader());
            this.engine = factory.getEngineByName(this.language);
            if (this.engine instanceof GroovyScriptEngineImpl) {
                ((GroovyScriptEngineImpl)this.engine).setClassLoader(new GroovyClassLoader(context.getClassLoader(), new CompilerConfiguration()));
            }
        }
        this.context = context;
        this.bindings = this.engine.createBindings();
        Set<String> keys = parameters.keySet();
        if (keys != null) {
            for (String key : keys) {
                Object value = parameters.get(key);
                if (key.equals("node")) {
                    this.rootNode = value;
                }
                this.bindings.put(key, value);
            }
        }
    }

    @Override
    public Object resolve(String query) {
        return this.resolve(this.rootNode, query);
    }

    @Override
    public Object resolve(Object context, String query) {
        if (context == null) {
            context = this.rootNode;
        }
        this.bindings.put("node", context);
        this.bindings.put("root", this.rootNode);
        this.bindings.put("context", (Object)this.context);
        try {
            if (query == null) {
                return null;
            }
            if (this.includes != null) {
                for (String include : this.includes) {
                    URI uri = this.context.getResource(include);
                    if (uri == null) continue;
                    String aux = this.includeExpression(uri.getPath()) + "\n";
                    query = aux + query;
                }
            }
            return this.engine.eval(query, this.bindings);
        }
        catch (ScriptException e) {
            log.error((Object)("The query: [" + query + "] has an error"));
            throw new WalkModException(e);
        }
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }

    public String includeExpression(String include) {
        if ("groovy".equals(this.language)) {
            return "evaluate(new File(\"" + include + "\"));";
        }
        return "";
    }
}

