/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.walkmod.ChainAdapter;
import org.walkmod.ChainInvocation;
import org.walkmod.ChainReader;
import org.walkmod.ChainWalker;
import org.walkmod.ChainWalkerAdapter;
import org.walkmod.ChainWriter;
import org.walkmod.Resource;
import org.walkmod.conf.entities.ChainConfig;
import org.walkmod.conf.entities.ReaderConfig;
import org.walkmod.conf.entities.WalkerConfig;
import org.walkmod.conf.entities.WriterConfig;
import org.walkmod.exceptions.WalkModException;
import org.walkmod.impl.DefaultChainWalkerAdapter;
import org.walkmod.impl.DefaultChainWalkerInvocation;

public class DefaultChainAdapter
implements ChainAdapter {
    private String name;
    private ChainConfig ac;
    private ChainInvocation ai;
    private Resource<?> model;
    private Map<String, Object> params = new HashMap<String, Object>();
    private ChainWalkerAdapter walkerAdapter;
    private ChainWriter modelWriter;
    private static final Log LOG = LogFactory.getLog(DefaultChainAdapter.class);

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setChainConfig(ChainConfig ac) {
        this.ac = ac;
    }

    @Override
    public ChainConfig getChainConfig() {
        return this.ac;
    }

    @Override
    public ChainInvocation getChainInvocation() {
        return this.ai;
    }

    @Override
    public void setChainInvocation(ChainInvocation ai) {
        this.ai = ai;
    }

    @Override
    public Resource<?> getResource() {
        return this.model;
    }

    @Override
    public void setResource(Resource<?> model) {
        this.model = model;
    }

    @Override
    public Map<String, Object> getParams() {
        return this.params;
    }

    @Override
    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    @Override
    public void prepare() throws WalkModException {
        this.setName(this.ac.getName());
        ReaderConfig readerConfig = this.ac.getReaderConfig();
        WriterConfig writerConfig = this.ac.getWriterConfig();
        String modelName = readerConfig.getPath();
        String modelType = readerConfig.getType();
        ChainReader reader = readerConfig.getModelReader();
        if (reader == null) {
            try {
                reader = (ChainReader)this.ac.getConfiguration().getBean(modelType, readerConfig.getParameters());
            }
            catch (Exception e2) {
                throw new WalkModException("The model " + modelName + ", whose type is " + modelType + "in the architecture " + this.getName() + " cannot be loaded ", e2);
            }
        }
        readerConfig.setModelReader(reader);
        reader.setPath(readerConfig.getPath());
        reader.setExcludes(readerConfig.getExcludes());
        reader.setIncludes(readerConfig.getIncludes());
        try {
            this.setResource(reader.read());
            LOG.debug((Object)("Model " + modelName + " loaded"));
        }
        catch (Exception e2) {
            throw new WalkModException("The model " + modelName + ", whose type is " + modelType + "in the architecture " + this.getName() + " cannot be read ", e2);
        }
        WalkerConfig wc = this.ac.getWalkerConfig();
        DefaultChainWalkerAdapter wa = new DefaultChainWalkerAdapter();
        this.setWalkerAdapter(wa);
        ChainWalker walker = wc.getWalker();
        if (walker == null) {
            walker = (ChainWalker)this.ac.getConfiguration().getBean(wc.getType(), wc.getParams());
        }
        wc.setWalker(walker);
        wa.setWalker(walker);
        wa.setWalkerConfig(wc);
        wa.setArchitectureProxy(this);
        wa.setWalkerInvocation(new DefaultChainWalkerInvocation());
        ChainWriter writer = writerConfig.getModelWriter();
        if (writer == null) {
            try {
                writer = (ChainWriter)this.ac.getConfiguration().getBean(writerConfig.getType(), writerConfig.getParams());
            }
            catch (Exception e2) {
                throw new WalkModException("The writer , whose type is " + writerConfig.getType() + "in the architecture " + this.getName() + " cannot be read ", e2);
            }
        }
        writerConfig.setModelWriter(writer);
        writer.setPath(writerConfig.getPath());
        this.setChainWriter(writer);
        wa.prepare();
        this.ai.init(this);
    }

    @Override
    public void execute() throws WalkModException {
        this.ai.invoke();
    }

    @Override
    public ChainWalkerAdapter getWalkerAdapter() {
        return this.walkerAdapter;
    }

    @Override
    public void setWalkerAdapter(ChainWalkerAdapter walkerAdapter) {
        this.walkerAdapter = walkerAdapter;
    }

    @Override
    public void setChainWriter(ChainWriter writer) {
        this.modelWriter = writer;
    }

    @Override
    public ChainWriter getChainWriter() {
        return this.modelWriter;
    }
}

