/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.conf.providers;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.walkmod.conf.ChainProvider;
import org.walkmod.conf.ConfigurationException;
import org.walkmod.conf.ConfigurationProvider;
import org.walkmod.conf.entities.ChainConfig;
import org.walkmod.conf.entities.Configuration;
import org.walkmod.conf.entities.MergePolicyConfig;
import org.walkmod.conf.entities.PluginConfig;
import org.walkmod.conf.entities.ProviderConfig;
import org.walkmod.conf.entities.ReaderConfig;
import org.walkmod.conf.entities.TransformationConfig;
import org.walkmod.conf.entities.WalkerConfig;
import org.walkmod.conf.entities.impl.ChainConfigImpl;
import org.walkmod.conf.entities.impl.MergePolicyConfigImpl;
import org.walkmod.conf.entities.impl.ParserConfigImpl;
import org.walkmod.conf.entities.impl.PluginConfigImpl;
import org.walkmod.conf.entities.impl.ProviderConfigImpl;
import org.walkmod.conf.entities.impl.TransformationConfigImpl;
import org.walkmod.conf.entities.impl.WalkerConfigImpl;
import org.walkmod.conf.entities.impl.WriterConfigImpl;
import org.walkmod.util.DomHelper;
import org.xml.sax.InputSource;

public class XMLConfigurationProvider
implements ConfigurationProvider,
ChainProvider {
    private String configFileName;
    private boolean errorIfMissing;
    private Configuration configuration;
    private Map<String, String> dtdMappings;
    private Document document;
    private static final Log LOG = LogFactory.getLog(XMLConfigurationProvider.class);

    public XMLConfigurationProvider() {
        this("walkmod.xml", true);
    }

    public XMLConfigurationProvider(String configFileName, boolean errorIfMissing) {
        this.configFileName = configFileName;
        this.errorIfMissing = errorIfMissing;
        HashMap<String, String> mappings = new HashMap<String, String>();
        mappings.put("-//UML Dreams Group//WalkMod 1.0//EN", "walkmod-1.0.dtd");
        this.setDtdMappings(mappings);
    }

    public void setDtdMappings(Map<String, String> mappings) {
        this.dtdMappings = Collections.unmodifiableMap(mappings);
    }

    public Map<String, String> getDtdMappings() {
        return this.dtdMappings;
    }

    @Override
    public void init(Configuration configuration) {
        this.configuration = configuration;
        this.document = this.loadDocument(this.configFileName);
    }

    private Document loadDocument(String file) {
        Document doc = null;
        URL url = null;
        File f = new File(file);
        if (f.exists()) {
            try {
                url = f.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new ConfigurationException("Unable to load " + file, e);
            }
        }
        if (url == null) {
            url = ClassLoader.getSystemResource(file);
        }
        InputStream is = null;
        if (url == null) {
            if (this.errorIfMissing) {
                throw new ConfigurationException("Could not open files of the name " + file);
            }
            LOG.info((Object)("Unable to locate configuration files of the name " + file + ", skipping"));
            return doc;
        }
        try {
            is = url.openStream();
            InputSource in = new InputSource(is);
            in.setSystemId(url.toString());
            doc = DomHelper.parse(in, this.dtdMappings);
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to load " + file, e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                LOG.error((Object)"Unable to close input stream", (Throwable)e);
            }
        }
        if (doc != null) {
            LOG.debug((Object)"Wallmod configuration parsed");
        }
        return doc;
    }

    private Map<String, Object> getParams(Element paramsElement) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        if (paramsElement == null) {
            return params;
        }
        NodeList childNodes = paramsElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() != 1 || !"param".equals(childNode.getNodeName())) continue;
            Element paramElement = (Element)childNode;
            String paramName = paramElement.getAttribute("name");
            String val = this.getContent(paramElement);
            if (val.length() <= 0) continue;
            char startChar = val.charAt(0);
            char endChar = val.charAt(val.length() - 1);
            if (startChar == '{' && endChar == '}') {
                try {
                    JSONObject o = JSON.parseObject((String)val);
                    params.put(paramName, o);
                }
                catch (JSONException e) {
                    params.put(paramName, val);
                }
                continue;
            }
            if (startChar == '[' && endChar == ']') {
                try {
                    JSONArray array = JSON.parseArray((String)val);
                    params.put(paramName, array);
                }
                catch (JSONException e) {
                    params.put(paramName, val);
                }
                continue;
            }
            params.put(paramName, val);
        }
        return params;
    }

    private String getContent(Element element) {
        StringBuilder paramValue = new StringBuilder();
        NodeList childNodes = element.getChildNodes();
        for (int j = 0; j < childNodes.getLength(); ++j) {
            String val;
            Node currentNode = childNodes.item(j);
            if (currentNode == null || currentNode.getNodeType() != 3 || (val = currentNode.getNodeValue()) == null) continue;
            paramValue.append(val.trim());
        }
        return paramValue.toString().trim();
    }

    @Override
    public void loadChains() throws ConfigurationException {
        Element rootElement = this.document.getDocumentElement();
        NodeList children = rootElement.getChildNodes();
        int childSize = children.getLength();
        for (int i = 0; i < childSize; ++i) {
            ChainConfigImpl ac;
            Node childNode = children.item(i);
            if (!(childNode instanceof Element)) continue;
            Element child = (Element)childNode;
            String nodeName = child.getNodeName();
            if ("chain".equals(nodeName)) {
                ac = new ChainConfigImpl();
                if ("".equals(child.getAttribute("name"))) {
                    if (i == 0) {
                        ac.setName("chain_" + (i + 1));
                    } else {
                        ac.setName("chain_" + (i + 1));
                    }
                } else {
                    ac.setName(child.getAttribute("name"));
                }
                NodeList childrenModel = child.getChildNodes();
                ac.setParameters(this.getParams(child));
                int index = 0;
                if ("reader".equals(childrenModel.item(index).getNodeName())) {
                    this.loadReaderConfig((Element)childrenModel.item(index), ac);
                    ++index;
                } else {
                    this.addDefaultReaderConfig(ac);
                }
                if (index >= childrenModel.getLength()) {
                    throw new ConfigurationException("Invalid architecture definition for the element" + ac.getName());
                }
                if ("walker".equals(childrenModel.item(index).getNodeName())) {
                    this.loadWalkerConfig((Element)childrenModel.item(index), ac);
                    ++index;
                } else if ("transformation".equals(childrenModel.item(index).getNodeName())) {
                    this.addDefaultWalker(ac, child);
                } else {
                    throw new ConfigurationException("Invalid transformation chain. A walker or at least one transformation must be specified");
                }
                if (index > childrenModel.getLength()) {
                    throw new ConfigurationException("Invalid architecture definition for the element" + ac.getName());
                }
                boolean found = false;
                while (index < childrenModel.getLength() && !found) {
                    if ("writer".equals(childrenModel.item(index).getNodeName())) {
                        found = true;
                        this.loadWriter((Element)childrenModel.item(index), ac);
                    }
                    ++index;
                }
                if (!found) {
                    this.addDefaultWriterConfig(ac);
                }
                this.configuration.addChainConfig(ac);
                continue;
            }
            if (!"transformation".equals(nodeName)) continue;
            ac = new ChainConfigImpl();
            ac.setName("chain_1");
            List<TransformationConfig> transformationConfigs = this.getTransformationItems(rootElement, true);
            WalkerConfigImpl wc = new WalkerConfigImpl();
            wc.setType(null);
            wc.setTransformations(transformationConfigs);
            this.addDefaultReaderConfig(ac);
            ac.setWalkerConfig(wc);
            this.addDefaultWriterConfig(ac);
            this.configuration.addChainConfig(ac);
            i = i + transformationConfigs.size() - 1;
        }
        LOG.debug((Object)"Transformation chains loaded");
    }

    public void addDefaultReaderConfig(ChainConfig ac) {
        ReaderConfig readerConfig = new ReaderConfig();
        readerConfig.setPath(null);
        readerConfig.setType(null);
        ac.setReaderConfig(readerConfig);
    }

    public void loadReaderConfig(Element element, ChainConfig ac) throws ConfigurationException {
        ReaderConfig readerConfig = new ReaderConfig();
        if ("reader".equals(element.getNodeName())) {
            if ("".equals(element.getAttribute("path"))) {
                throw new ConfigurationException("Invalid reader definition: A path attribute must be specified");
            }
            readerConfig.setPath(element.getAttribute("path"));
            if ("".equals(element.getAttribute("type"))) {
                readerConfig.setType(null);
            } else {
                readerConfig.setType(element.getAttribute("type"));
            }
            readerConfig.setParameters(this.getParams(element));
            NodeList childs = element.getChildNodes();
            if (childs != null) {
                Iterator iterator;
                Object include;
                Object exclude;
                int max = childs.getLength();
                LinkedList<String> excludes = new LinkedList<String>();
                LinkedList<String> includes = new LinkedList<String>();
                for (int i = 0; i < max; ++i) {
                    Node n = childs.item(i);
                    String nodeName = n.getNodeName();
                    if ("exclude".equals(nodeName)) {
                        exclude = (Element)n;
                        excludes.add(exclude.getAttribute("wildcard"));
                        continue;
                    }
                    if ("include".equals(nodeName)) {
                        include = (Element)n;
                        includes.add(include.getAttribute("wildcard"));
                        continue;
                    }
                    throw new ConfigurationException("Invalid reader definition. Only exclude or include tags are supported");
                }
                if (!excludes.isEmpty()) {
                    String[] excludesArray = new String[excludes.size()];
                    int j = 0;
                    iterator = excludes.iterator();
                    while (iterator.hasNext()) {
                        excludesArray[j] = exclude = (String)iterator.next();
                        ++j;
                    }
                    readerConfig.setExcludes(excludesArray);
                }
                if (!includes.isEmpty()) {
                    String[] includesArray = new String[includes.size()];
                    int j = 0;
                    iterator = includes.iterator();
                    while (iterator.hasNext()) {
                        includesArray[j] = include = (String)iterator.next();
                        ++j;
                    }
                    readerConfig.setIncludes(includesArray);
                }
            }
        } else {
            throw new ConfigurationException("Invalid architecture definition. A reader element must be defined in the architecture element " + ac.getName());
        }
        ac.setReaderConfig(readerConfig);
    }

    public void addDefaultWalker(ChainConfig ac, Element parentWalkerNode) {
        WalkerConfigImpl wc = new WalkerConfigImpl();
        wc.setType(null);
        wc.setParserConfig(new ParserConfigImpl());
        wc.setTransformations(this.getTransformationItems(parentWalkerNode, false));
        ac.setWalkerConfig(wc);
    }

    public void loadWalkerConfig(Element element, ChainConfig ac) {
        int transformationIndex;
        NodeList children;
        WalkerConfigImpl wc;
        Element walkerNode = element;
        if ("walker".equals(walkerNode.getNodeName())) {
            wc = new WalkerConfigImpl();
            String type = walkerNode.getAttribute("type");
            if ("".equals(type)) {
                wc.setType(null);
            } else {
                wc.setType(type);
            }
            wc.setParams(this.getParams(walkerNode));
            wc.setRootNamespace(walkerNode.getAttribute("root-namespace"));
            children = walkerNode.getChildNodes();
            if (children.getLength() > 3) {
                throw new ConfigurationException("Invalid walker definition in the architecture" + ac.getName() + ". Please, verify the dtd");
            }
            transformationIndex = wc.getParams().size();
            String nodeName = ((Element)children.item(transformationIndex)).getNodeName();
            if ("parser".equals(nodeName)) {
                this.loadParserConfig((Element)children.item(transformationIndex), wc);
                transformationIndex = 1;
            } else {
                wc.setParserConfig(new ParserConfigImpl());
            }
        } else {
            throw new ConfigurationException("Invalid architecture definition. A walker element must be defined in the architecture element " + ac.getName());
        }
        this.loadTransformationConfigs((Element)children.item(transformationIndex), wc);
        ac.setWalkerConfig(wc);
    }

    public void loadParserConfig(Element element, WalkerConfig wc) {
        String nodeName = element.getNodeName();
        if ("parser".equals(nodeName)) {
            ParserConfigImpl pc = new ParserConfigImpl();
            if ("".equals(element.getAttribute("type"))) {
                pc.setType(null);
            } else {
                pc.setType(element.getAttribute("type"));
            }
            pc.setParameters(this.getParams(element));
        }
    }

    public List<TransformationConfig> getTransformationItems(Element element, boolean exceptionsEnabled) {
        LinkedList<TransformationConfig> transformationConfigs = new LinkedList<TransformationConfig>();
        NodeList transfNodes = element.getChildNodes();
        for (int j = 0; j < transfNodes.getLength(); ++j) {
            element = (Element)transfNodes.item(j);
            if (!"transformation".equals(element.getNodeName())) continue;
            TransformationConfigImpl tc = new TransformationConfigImpl();
            String name = element.getAttribute("name");
            String visitor = element.getAttribute("type");
            String isMergeable = element.getAttribute("isMergeable");
            String mergePolicy = element.getAttribute("merge-policy");
            if ("".equals(visitor)) {
                throw new ConfigurationException("Invalid transformation definition: A type attribute must be specified");
            }
            if ("".equals(name)) {
                name = visitor;
            }
            tc.setName(name);
            tc.setType(visitor);
            tc.setParameters(this.getParams(element));
            if (isMergeable != null && !"".equals(isMergeable)) {
                tc.isMergeable(Boolean.parseBoolean(isMergeable));
            }
            if (!"".equals(mergePolicy.trim())) {
                tc.isMergeable(true);
                tc.setMergePolicy(mergePolicy);
            }
            transformationConfigs.add(tc);
        }
        return transformationConfigs;
    }

    public void loadTransformationConfigs(Element element, WalkerConfig wc) {
        LinkedList<TransformationConfig> transformationConfigs = new LinkedList();
        String nodeName = element.getNodeName();
        if (!"transformations".equals(nodeName)) {
            throw new ConfigurationException("Invalid walker definition. A walker element must contain a \"transformations\" element ");
        }
        transformationConfigs = this.getTransformationItems(element, true);
        wc.setTransformations(transformationConfigs);
    }

    public void addDefaultWriterConfig(ChainConfig ac) {
        WriterConfigImpl wc = new WriterConfigImpl();
        wc.setPath(ac.getReaderConfig().getPath());
        wc.setType(null);
        ac.setWriterConfig(wc);
    }

    public void loadWriter(Element child, ChainConfig ac) {
        if ("writer".equals(child.getNodeName())) {
            WriterConfigImpl wc = new WriterConfigImpl();
            String path = child.getAttribute("path");
            if ("".equals(path)) {
                throw new ConfigurationException("Invalid writer definition: A path attribute must be specified");
            }
            wc.setPath(path);
            String type = child.getAttribute("type");
            if ("".equals(type)) {
                wc.setType(null);
            } else {
                wc.setType(type);
            }
            NodeList childs = child.getChildNodes();
            if (childs != null) {
                Iterator iterator;
                Object include;
                Object exclude;
                int max = childs.getLength();
                LinkedList<String> excludes = new LinkedList<String>();
                LinkedList<String> includes = new LinkedList<String>();
                for (int i = 0; i < max; ++i) {
                    Node n = childs.item(i);
                    String nodeName = n.getNodeName();
                    if ("exclude".equals(nodeName)) {
                        exclude = (Element)n;
                        excludes.add(exclude.getAttribute("wildcard"));
                        continue;
                    }
                    if ("include".equals(nodeName)) {
                        include = (Element)n;
                        includes.add(include.getAttribute("wildcard"));
                        continue;
                    }
                    if ("param".equals(nodeName)) continue;
                    throw new ConfigurationException("Invalid writer definition. Only exclude or include tags are supported");
                }
                if (!excludes.isEmpty()) {
                    String[] excludesArray = new String[excludes.size()];
                    int j = 0;
                    iterator = excludes.iterator();
                    while (iterator.hasNext()) {
                        excludesArray[j] = exclude = (String)iterator.next();
                        ++j;
                    }
                    wc.setExcludes(excludesArray);
                }
                if (!includes.isEmpty()) {
                    String[] includesArray = new String[includes.size()];
                    int j = 0;
                    iterator = includes.iterator();
                    while (iterator.hasNext()) {
                        includesArray[j] = include = (String)iterator.next();
                        ++j;
                    }
                    wc.setIncludes(includesArray);
                }
            }
            wc.setParams(this.getParams(child));
            ac.setWriterConfig(wc);
        }
    }

    @Override
    public void load() throws ConfigurationException {
        Map<String, Object> params = this.getParams(this.document.getDocumentElement());
        this.configuration.setParameters(params);
        this.loadPlugins();
        this.loadProviders();
        this.loadMergePolicies();
        this.loadChains();
    }

    private void loadProviders() {
        Element rootElement = this.document.getDocumentElement();
        NodeList children = rootElement.getChildNodes();
        LinkedList<ProviderConfig> providers = new LinkedList<ProviderConfig>();
        int childSize = children.getLength();
        for (int i = 0; i < childSize; ++i) {
            Node childNode = children.item(i);
            if (!"conf-providers".equals(childNode.getNodeName())) continue;
            Element child = (Element)childNode;
            NodeList providersNodes = child.getChildNodes();
            int providersSize = providersNodes.getLength();
            for (int j = 0; j < providersSize; ++j) {
                Node providerNode = providersNodes.item(j);
                if (!"conf-provider".equals(providerNode.getNodeName())) continue;
                Element providerElem = (Element)providerNode;
                ProviderConfigImpl pc = new ProviderConfigImpl();
                pc.setType(providerElem.getAttribute("type"));
                pc.setParameters(this.getParams(providerElem));
                providers.add(pc);
            }
        }
        this.configuration.setProviderConfigurations(providers);
    }

    private void loadMergePolicies() {
        Element rootElement = this.document.getDocumentElement();
        NodeList children = rootElement.getChildNodes();
        int childSize = children.getLength();
        LinkedList<MergePolicyConfig> mergePolicies = new LinkedList<MergePolicyConfig>();
        for (int i = 0; i < childSize; ++i) {
            Node childNode = children.item(i);
            if (!"merge-policies".equals(childNode.getNodeName())) continue;
            Element child = (Element)childNode;
            NodeList policiesNodes = child.getChildNodes();
            int policiesSize = policiesNodes.getLength();
            for (int j = 0; j < policiesSize; ++j) {
                Node policyNode = policiesNodes.item(j);
                if (!"policy".equals(policyNode.getNodeName())) continue;
                Element policyElem = (Element)policyNode;
                MergePolicyConfigImpl policy = new MergePolicyConfigImpl();
                policy.setName(policyElem.getAttribute("name"));
                String defaultOP = policyElem.getAttribute("default-object-policy");
                if (!"".equals(defaultOP.trim())) {
                    policy.setDefaultObjectPolicy(defaultOP);
                } else {
                    policy.setDefaultObjectPolicy(null);
                }
                String defaultTP = policyElem.getAttribute("default-type-policy");
                if (!"".equals(defaultTP)) {
                    policy.setDefaultTypePolicy(defaultTP);
                } else {
                    policy.setDefaultTypePolicy(null);
                }
                NodeList entriesNodes = policyElem.getChildNodes();
                int entriesSize = entriesNodes.getLength();
                HashMap<String, String> policyEntries = new HashMap<String, String>();
                policy.setPolicyEntries(policyEntries);
                mergePolicies.add(policy);
                for (int k = 0; k < entriesSize; ++k) {
                    Node entry = entriesNodes.item(k);
                    if (!"policy-entry".equals(entry.getNodeName())) continue;
                    Element entryElem = (Element)entry;
                    String otype = entryElem.getAttribute("object-type");
                    String ptype = entryElem.getAttribute("policy-type");
                    if ("".equals(otype.trim()) || "".equals(ptype.trim())) continue;
                    policyEntries.put(otype, ptype);
                }
            }
        }
        this.configuration.setMergePolicies(mergePolicies);
    }

    private void loadPlugins() {
        Element rootElement = this.document.getDocumentElement();
        NodeList children = rootElement.getChildNodes();
        int childSize = children.getLength();
        for (int i = 0; i < childSize; ++i) {
            Node childNode = children.item(i);
            if (!"plugins".equals(childNode.getNodeName())) continue;
            Element child = (Element)childNode;
            LinkedList<PluginConfig> plugins = new LinkedList<PluginConfig>();
            this.configuration.setPlugins(plugins);
            NodeList pluginNodes = child.getChildNodes();
            int pluginSize = pluginNodes.getLength();
            for (int j = 0; j < pluginSize; ++j) {
                Node pluginNode = pluginNodes.item(j);
                if (!"plugin".equals(pluginNode.getNodeName())) continue;
                Element pluginElement = (Element)pluginNode;
                PluginConfigImpl pc = new PluginConfigImpl();
                String groupId = pluginElement.getAttribute("groupId");
                String artifactId = pluginElement.getAttribute("artifactId");
                String version = pluginElement.getAttribute("version");
                if (groupId == null) {
                    throw new ConfigurationException("Invalid plugin definition. A groupId is necessary.");
                }
                if (artifactId == null) {
                    throw new ConfigurationException("Invalid plugin definition. A artifactId is necessary.");
                }
                if (version == null) {
                    throw new ConfigurationException("Invalid plugin definition. A version is necessary.");
                }
                pc.setGroupId(groupId);
                pc.setArtifactId(artifactId);
                pc.setVersion(version);
                plugins.add(pc);
            }
        }
    }
}

