/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.conf.providers;

import java.util.Collection;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.walkmod.conf.BeanFactoryProvider;
import org.walkmod.conf.ConfigurationException;
import org.walkmod.conf.ConfigurationProvider;
import org.walkmod.conf.entities.Configuration;
import org.walkmod.conf.entities.PluginConfig;

public class SpringConfigurationProvider
implements ConfigurationProvider,
BeanFactoryProvider {
    private Configuration configuration;
    private String config;

    public SpringConfigurationProvider() {
        this("application-context.xml");
    }

    public SpringConfigurationProvider(String config) {
        this.config = config;
    }

    @Override
    public void init(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void loadBeanFactory() throws ConfigurationException {
        GenericApplicationContext ctx = new GenericApplicationContext();
        XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)ctx);
        reader.setBeanClassLoader(this.configuration.getClassLoader());
        reader.loadBeanDefinitions((Resource)new ClassPathResource(this.config, this.configuration.getClassLoader()));
        Collection<PluginConfig> plugins = this.configuration.getPlugins();
        if (plugins != null) {
            for (PluginConfig plugin : plugins) {
                String descriptorName = plugin.getArtifactId();
                if (!descriptorName.startsWith("walkmod-")) {
                    descriptorName = "walkmod-" + descriptorName;
                }
                if (!descriptorName.endsWith("-plugin")) {
                    descriptorName = descriptorName + "-plugin";
                }
                reader.loadBeanDefinitions((Resource)new ClassPathResource("META-INF/walkmod/" + descriptorName + ".xml", this.configuration.getClassLoader()));
            }
        }
        ctx.refresh();
        this.configuration.setBeanFactory((BeanFactory)ctx);
    }

    @Override
    public void load() throws ConfigurationException {
        this.loadBeanFactory();
    }
}

