/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.conf.providers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.walkmod.conf.ConfigurationException;
import org.walkmod.conf.ConfigurationProvider;
import org.walkmod.conf.entities.Configuration;
import org.walkmod.conf.entities.PluginConfig;
import org.walkmod.conf.entities.impl.PluginConfigImpl;
import org.walkmod.util.DomHelper;
import org.xml.sax.InputSource;

public class PluginsConfigurationProvider
implements ConfigurationProvider {
    private Configuration configuration;
    private Map<String, String> dtdMappings;
    private Document document;
    private static final Log LOG = LogFactory.getLog(PluginsConfigurationProvider.class);
    private String fileName;
    private boolean errorIfMissing;

    public PluginsConfigurationProvider() {
        this("default-plugins.xml", true);
    }

    public PluginsConfigurationProvider(String fileName, boolean errorIfMissing) {
        this.fileName = fileName;
        this.errorIfMissing = errorIfMissing;
        HashMap<String, String> mappings = new HashMap<String, String>();
        mappings.put("-//WALKMOD//WalkMod 1.0//EN", "walkmod-plugins-1.0.dtd");
        this.setDtdMappings(mappings);
    }

    public void setDtdMappings(Map<String, String> mappings) {
        this.dtdMappings = Collections.unmodifiableMap(mappings);
    }

    public Map<String, String> getDtdMappings() {
        return this.dtdMappings;
    }

    @Override
    public void init(Configuration configuration) {
        this.configuration = configuration;
        this.document = this.lookUpDocument();
    }

    private Document lookUpDocument() {
        Document doc = null;
        URL url = null;
        if (this.configuration == null) {
            throw new ConfigurationException("Missing default values configuration");
        }
        File f = new File(this.fileName);
        if (f.exists()) {
            try {
                url = f.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new ConfigurationException("Unable to load " + this.fileName, e);
            }
        }
        if (url == null) {
            url = this.configuration.getClassLoader().getResource(this.fileName);
        }
        InputStream is = null;
        if (url == null) {
            if (this.errorIfMissing) {
                throw new ConfigurationException("Could not open files of the name " + this.fileName);
            }
            LOG.info((Object)("Unable to locate default values configuration of the name " + f.getName() + ", skipping"));
            return doc;
        }
        try {
            is = url.openStream();
            InputSource in = new InputSource(is);
            in.setSystemId(url.toString());
            doc = DomHelper.parse(in, this.dtdMappings);
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to load " + this.fileName, e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                LOG.error((Object)"Unable to close input stream", (Throwable)e);
            }
        }
        if (doc != null) {
            LOG.debug((Object)"Default Walkmod plugins configuration parsed");
        }
        return doc;
    }

    @Override
    public void load() throws ConfigurationException {
        Collection<PluginConfig> plugins = this.configuration.getPlugins();
        if (plugins == null) {
            plugins = new LinkedList<PluginConfig>();
            this.configuration.setPlugins(plugins);
        }
        Element rootElement = this.document.getDocumentElement();
        NodeList childNodes = rootElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() != 1 || !"plugin".equals(childNode.getNodeName())) continue;
            Element paramElement = (Element)childNode;
            String groupId = paramElement.getAttribute("groupId");
            String artifactId = paramElement.getAttribute("artifactId");
            String version = paramElement.getAttribute("version");
            PluginConfigImpl defaultPlugin = new PluginConfigImpl();
            defaultPlugin.setGroupId(groupId);
            defaultPlugin.setArtifactId(artifactId);
            defaultPlugin.setVersion(version);
            plugins.add(defaultPlugin);
        }
    }
}

