/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.conf.providers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.walkmod.conf.ConfigurationException;
import org.walkmod.conf.ConfigurationProvider;
import org.walkmod.conf.entities.ChainConfig;
import org.walkmod.conf.entities.Configuration;
import org.walkmod.conf.entities.MergePolicyConfig;
import org.walkmod.conf.entities.ReaderConfig;
import org.walkmod.conf.entities.TransformationConfig;
import org.walkmod.conf.entities.WalkerConfig;
import org.walkmod.conf.entities.WriterConfig;
import org.walkmod.conf.entities.impl.MergePolicyConfigImpl;
import org.walkmod.util.DomHelper;
import org.xml.sax.InputSource;

public class LanguageConfigurationProvider
implements ConfigurationProvider {
    private String suffixFileName;
    private boolean errorIfMissing;
    private Configuration configuration;
    private Map<String, String> dtdMappings;
    private Document document;
    private static final String DEFAULT_MERGE_ENGINE_NAME = "default";
    private static final Log LOG = LogFactory.getLog(LanguageConfigurationProvider.class);

    public LanguageConfigurationProvider() {
        this("defaults.xml", true);
    }

    public LanguageConfigurationProvider(String suffixFileName, boolean errorIfMissing) {
        this.suffixFileName = suffixFileName;
        this.errorIfMissing = errorIfMissing;
        HashMap<String, String> mappings = new HashMap<String, String>();
        mappings.put("-//WALKMOD//WalkMod 1.0//EN", "walkmod-lang-1.0.dtd");
        this.setDtdMappings(mappings);
    }

    public void setDtdMappings(Map<String, String> mappings) {
        this.dtdMappings = Collections.unmodifiableMap(mappings);
    }

    public Map<String, String> getDtdMappings() {
        return this.dtdMappings;
    }

    @Override
    public void init(Configuration configuration) {
        this.configuration = configuration;
        this.document = this.lookUpDocument();
    }

    private Document lookUpDocument() {
        Document doc = null;
        URL url = null;
        if (this.configuration == null) {
            throw new ConfigurationException("Missing default values configuration");
        }
        String defaults = this.configuration.getDefaultLanguage();
        String fileName = defaults == null ? "default-config.xml" : "META-INF/walkmod/walkmod-" + defaults + "-" + this.suffixFileName;
        File f = new File(fileName);
        if (f.exists()) {
            try {
                url = f.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new ConfigurationException("Unable to load " + fileName, e);
            }
        }
        if (url == null) {
            url = this.configuration.getClassLoader().getResource(fileName);
        }
        InputStream is = null;
        if (url == null) {
            if (this.errorIfMissing) {
                throw new ConfigurationException("Could not open files of the name " + fileName);
            }
            LOG.info((Object)("Unable to locate default values configuration of the name " + f.getName() + ", skipping"));
            return doc;
        }
        try {
            is = url.openStream();
            InputSource in = new InputSource(is);
            in.setSystemId(url.toString());
            doc = DomHelper.parse(in, this.dtdMappings);
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to load " + fileName, e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                LOG.error((Object)"Unable to close input stream", (Throwable)e);
            }
        }
        if (doc != null) {
            LOG.debug((Object)"Walkmod configuration parsed");
        }
        return doc;
    }

    @Override
    public void load() throws ConfigurationException {
        this.updateNulls();
        this.loadMergePolicies();
    }

    private void updateNulls() {
        Collection<ChainConfig> ccs = this.configuration.getChainConfigs();
        Element rootElement = this.document.getDocumentElement();
        if (ccs != null) {
            for (ChainConfig cc : ccs) {
                List<TransformationConfig> transformations;
                WalkerConfig walkc;
                WriterConfig wc;
                ReaderConfig rc = cc.getReaderConfig();
                if (rc.getType() == null) {
                    rc.setType(rootElement.getAttribute("reader"));
                }
                if (rc.getPath() == null) {
                    rc.setPath(rootElement.getAttribute("path"));
                }
                if ((wc = cc.getWriterConfig()).getType() == null) {
                    wc.setType(rootElement.getAttribute("writer"));
                }
                if (wc.getPath() == null) {
                    wc.setPath(rootElement.getAttribute("path"));
                }
                if ((walkc = cc.getWalkerConfig()).getType() == null) {
                    walkc.setType(rootElement.getAttribute("walker"));
                }
                if (walkc.getParserConfig().getType() == null && !"".equals(rootElement.getAttribute("parser"))) {
                    walkc.getParserConfig().setType(rootElement.getAttribute("parser"));
                }
                if ((transformations = walkc.getTransformations()) == null) continue;
                for (TransformationConfig tc : transformations) {
                    if (!tc.isMergeable() || tc.getMergePolicy() != null) continue;
                    tc.setMergePolicy(DEFAULT_MERGE_ENGINE_NAME);
                }
            }
        }
    }

    private void loadMergePolicies() {
        Element rootElement = this.document.getDocumentElement();
        NodeList children = rootElement.getChildNodes();
        int childSize = children.getLength();
        Collection<MergePolicyConfig> mergePolicies = this.configuration.getMergePolicies();
        if (mergePolicies == null) {
            mergePolicies = new LinkedList<MergePolicyConfig>();
            this.configuration.setMergePolicies(mergePolicies);
        }
        MergePolicyConfigImpl policy = null;
        for (int j = 0; j < childSize; ++j) {
            Node childNode = children.item(j);
            if (!"policy".equals(childNode.getNodeName())) continue;
            Element policyElem = (Element)childNode;
            policy = new MergePolicyConfigImpl();
            policy.setName(DEFAULT_MERGE_ENGINE_NAME);
            String defaultOP = policyElem.getAttribute("default-object-policy");
            if (!"".equals(defaultOP.trim())) {
                policy.setDefaultObjectPolicy(defaultOP);
            } else {
                policy.setDefaultObjectPolicy(null);
            }
            String defaultTP = policyElem.getAttribute("default-type-policy");
            if (!"".equals(defaultTP)) {
                policy.setDefaultTypePolicy(defaultTP);
            } else {
                policy.setDefaultTypePolicy(null);
            }
            NodeList entriesNodes = policyElem.getChildNodes();
            int entriesSize = entriesNodes.getLength();
            HashMap<String, String> policyEntries = new HashMap<String, String>();
            policy.setPolicyEntries(policyEntries);
            for (int k = 0; k < entriesSize; ++k) {
                Node entry = entriesNodes.item(k);
                if (!"policy-entry".equals(entry.getNodeName())) continue;
                Element entryElem = (Element)entry;
                String otype = entryElem.getAttribute("object-type");
                String ptype = entryElem.getAttribute("policy-type");
                if ("".equals(otype.trim()) || "".equals(ptype.trim())) continue;
                policyEntries.put(otype, ptype);
            }
        }
        if (policy != null) {
            mergePolicies.add(policy);
        }
    }
}

