/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.conf.entities.impl;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanFactory;
import org.walkmod.conf.entities.ChainConfig;
import org.walkmod.conf.entities.Configuration;
import org.walkmod.conf.entities.MergePolicyConfig;
import org.walkmod.conf.entities.PluginConfig;
import org.walkmod.conf.entities.ProviderConfig;
import org.walkmod.exceptions.WalkModException;
import org.walkmod.merger.MergeEngine;
import org.walkmod.walkers.VisitorMessage;

public class ConfigurationImpl
implements Configuration {
    private Map<String, Object> parameters = new LinkedHashMap<String, Object>();
    private Map<String, ChainConfig> chainConfigs = new LinkedHashMap<String, ChainConfig>();
    private BeanFactory beanFactory = null;
    private Collection<PluginConfig> plugins;
    private ClassLoader classLoader = null;
    private Collection<MergePolicyConfig> mergePolicies;
    private Map<String, MergeEngine> mergeEngines = new LinkedHashMap<String, MergeEngine>();
    private String defaultLanguage = null;
    private Collection<ProviderConfig> providers;

    @Override
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @Override
    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    @Override
    public Collection<ChainConfig> getChainConfigs() {
        return this.chainConfigs.values();
    }

    @Override
    public void setChainConfigs(Collection<ChainConfig> chainConfigs) {
        this.chainConfigs.clear();
        for (ChainConfig current : chainConfigs) {
            current.setConfiguration(this);
            this.chainConfigs.put(current.getName(), current);
        }
    }

    @Override
    public boolean addChainConfig(ChainConfig architecture) {
        boolean result = this.chainConfigs.containsKey(architecture.getName());
        if (!result) {
            architecture.setConfiguration(this);
            this.chainConfigs.put(architecture.getName(), architecture);
        }
        return result;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    @Override
    public Object getBean(String name, Map<?, ?> parameters) {
        Object result = null;
        if (name == null || "".equals(name)) {
            return result;
        }
        if (this.beanFactory != null && this.beanFactory.containsBean(name)) {
            result = this.beanFactory.getBean(name);
        }
        if (result == null) {
            try {
                Class<?> clazz = this.getClassLoader().loadClass(name);
                result = clazz.newInstance();
            }
            catch (Exception e) {
                throw new WalkModException("Sorry, it is impossible to load the bean " + name + ". Please, assure that it is a valid class name and the library which contains it is in the classpath", e);
            }
        }
        if (result != null) {
            MutablePropertyValues pvs;
            BeanWrapperImpl bw = new BeanWrapperImpl(result);
            if (this.parameters != null) {
                pvs = new MutablePropertyValues(this.parameters);
                bw.setPropertyValues((PropertyValues)pvs, true, true);
            }
            if (parameters != null) {
                pvs = new MutablePropertyValues(parameters);
                bw.setPropertyValues((PropertyValues)pvs, true, true);
            }
        }
        return result;
    }

    @Override
    public void populate(Object element, Map<?, ?> parameters) {
        if (element != null) {
            BeanWrapperImpl bw = new BeanWrapperImpl(element);
            if (this.parameters != null) {
                bw.setPropertyValues(this.parameters);
            }
            bw.setPropertyValues(parameters);
        }
    }

    @Override
    public Collection<VisitorMessage> getVisitorMessages() {
        LinkedList<VisitorMessage> result = new LinkedList<VisitorMessage>();
        if (this.getChainConfigs() != null) {
            for (ChainConfig aqConfig : this.getChainConfigs()) {
                result.addAll(aqConfig.getWalkerConfig().getWalker().getVisitorMessages());
            }
        }
        return result;
    }

    @Override
    public Collection<PluginConfig> getPlugins() {
        return this.plugins;
    }

    @Override
    public void setPlugins(Collection<PluginConfig> plugins) {
        this.plugins = plugins;
    }

    @Override
    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            return this.getClass().getClassLoader();
        }
        return this.classLoader;
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public Collection<MergePolicyConfig> getMergePolicies() {
        return this.mergePolicies;
    }

    @Override
    public void setMergePolicies(Collection<MergePolicyConfig> mergePolicies) {
        this.mergePolicies = mergePolicies;
    }

    @Override
    public void setMergeEngines(Map<String, MergeEngine> mergeEngines) {
        this.mergeEngines = mergeEngines;
    }

    @Override
    public MergeEngine getMergeEngine(String name) {
        return this.mergeEngines.get(name);
    }

    @Override
    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    @Override
    public void setDefaultLanguage(String defaults) {
        this.defaultLanguage = defaults;
    }

    @Override
    public Collection<ProviderConfig> getProviderConfigurations() {
        return this.providers;
    }

    @Override
    public void setProviderConfigurations(Collection<ProviderConfig> providers) {
        this.providers = providers;
    }
}

