/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod;

import java.io.File;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.walkmod.ChainAdapter;
import org.walkmod.ChainAdapterFactory;
import org.walkmod.conf.ConfigurationManager;
import org.walkmod.conf.entities.ChainConfig;
import org.walkmod.conf.entities.Configuration;
import org.walkmod.conf.providers.IvyConfigurationProvider;
import org.walkmod.exceptions.InvalidConfigurationException;
import org.walkmod.exceptions.WalkModException;
import org.walkmod.impl.DefaultChainAdapterFactory;
import org.walkmod.writers.Summary;
import org.walkmod.writers.VisitorMessagesWriter;

public class WalkModFacade {
    private static Logger log = Logger.getLogger(WalkModFacade.class);
    private boolean offline = false;
    private boolean verbose = true;
    private boolean printError = false;
    private static final String DEFAULT_WALKMOD_FILE = "walkmod.xml";
    private File cfg;

    public WalkModFacade(File cfg, boolean offline, boolean verbose, boolean printError) {
        this.cfg = cfg;
        this.offline = offline;
        this.verbose = verbose;
        this.printError = printError;
    }

    public WalkModFacade(String cfg, boolean offline, boolean verbose, boolean printError) {
        this.cfg = new File(cfg);
        this.offline = offline;
        this.verbose = verbose;
        this.printError = printError;
    }

    public WalkModFacade(boolean offline, boolean verbose, boolean printError) {
        this(new File(DEFAULT_WALKMOD_FILE), offline, verbose, printError);
    }

    public WalkModFacade() {
        this(false, true, false);
    }

    public List<File> apply(String ... chains) throws InvalidConfigurationException {
        if (this.cfg.exists()) {
            if (this.verbose) {
                log.info((Object)(this.cfg.getAbsoluteFile() + " [ok]"));
            }
            IvyConfigurationProvider cp = new IvyConfigurationProvider(this.offline);
            ConfigurationManager cfgManager = null;
            Configuration config = null;
            DefaultChainAdapterFactory apf = null;
            try {
                cfgManager = new ConfigurationManager(this.cfg, cp);
                config = cfgManager.getConfiguration();
                apf = new DefaultChainAdapterFactory();
            }
            catch (Exception e) {
                if (this.verbose) {
                    if (!this.printError) {
                        log.error((Object)(this.cfg.getAbsolutePath() + " is invalid. Please, execute walkmod with -e to see the details."));
                    } else {
                        log.error((Object)"Invalid configuration", (Throwable)e);
                    }
                    return null;
                }
                throw new InvalidConfigurationException(e);
            }
            Summary.getInstance().clear();
            if (chains == null || chains.length == 0) {
                this.executeAllChains(apf, config);
            } else {
                for (String chain : chains) {
                    this.executeChainAdapter(apf, config, chain);
                }
            }
        } else if (this.verbose) {
            log.error((Object)(this.cfg.getAbsolutePath() + " does not exist. The root directory of your project must contain a walkmod.xml"));
        } else {
            throw new WalkModException(this.cfg.getAbsolutePath() + " does not exist. The root directory of your project must contain a walkmod.xml");
        }
        return Summary.getInstance().getWrittenFiles();
    }

    public List<File> check(String ... chains) throws InvalidConfigurationException {
        if (this.cfg.exists()) {
            if (this.verbose) {
                log.info((Object)(this.cfg.getAbsoluteFile() + " [ok]"));
            }
            IvyConfigurationProvider cp = new IvyConfigurationProvider(this.offline);
            ConfigurationManager cfgManager = null;
            Configuration config = null;
            DefaultChainAdapterFactory apf = null;
            try {
                cfgManager = new ConfigurationManager(this.cfg, cp);
                config = cfgManager.getConfiguration();
                apf = new DefaultChainAdapterFactory();
            }
            catch (Exception e) {
                if (this.verbose) {
                    if (!this.printError) {
                        log.error((Object)(this.cfg.getAbsolutePath() + " is invalid. Please, execute walkmod with -e to see the details."));
                    } else {
                        log.error((Object)"Invalid configuration", (Throwable)e);
                    }
                    return null;
                }
                throw new InvalidConfigurationException(e);
            }
            Collection<ChainConfig> tcgfs = config.getChainConfigs();
            for (ChainConfig tcfg : tcgfs) {
                tcfg.getWriterConfig().setType(VisitorMessagesWriter.class.getName());
                tcfg.getWriterConfig().setModelWriter(new VisitorMessagesWriter());
            }
            Summary.getInstance().clear();
            if (chains == null || chains.length == 0) {
                this.executeAllChains(apf, config);
            } else {
                for (String chain : chains) {
                    this.executeChainAdapter(apf, config, chain);
                }
            }
        } else if (this.verbose) {
            log.error((Object)(this.cfg.getAbsolutePath() + " does not exist. The root directory of your project must contain a walkmod.xml"));
        } else {
            throw new WalkModException(this.cfg.getAbsolutePath() + " does not exist. The root directory of your project must contain a walkmod.xml");
        }
        return Summary.getInstance().getWrittenFiles();
    }

    public void install() throws InvalidConfigurationException {
        if (this.cfg.exists()) {
            long startTime;
            if (this.verbose) {
                log.info((Object)(this.cfg.getAbsoluteFile() + " [ok]"));
            }
            IvyConfigurationProvider cp = new IvyConfigurationProvider();
            if (this.verbose) {
                log.info((Object)"** THE PLUGIN INSTALLATION STARTS **");
                System.out.print("----------------------------------------");
                System.out.println("----------------------------------------");
            }
            long endTime = startTime = System.currentTimeMillis();
            DecimalFormat myFormatter = new DecimalFormat("###.###");
            SimpleDateFormat df = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss", Locale.US);
            boolean error = false;
            try {
                ConfigurationManager cfgManager = new ConfigurationManager(this.cfg, cp);
                Configuration cf = cfgManager.getConfiguration();
            }
            catch (Exception e) {
                if (this.verbose) {
                    error = true;
                    endTime = System.currentTimeMillis();
                    double time = 0.0;
                    if (endTime > startTime) {
                        time = (double)(endTime - startTime) / 1000.0;
                    }
                    String timeMsg = myFormatter.format(time);
                    System.out.print("----------------------------------------");
                    System.out.println("----------------------------------------");
                    log.info((Object)"PLUGIN INSTALLATION FAILS");
                    System.out.println();
                    System.out.print("----------------------------------------");
                    System.out.println("----------------------------------------");
                    log.info((Object)("Total time: " + timeMsg + " seconds"));
                    log.info((Object)("Finished at: " + df.format(new Date())));
                    log.info((Object)("Final memory: " + Runtime.getRuntime().freeMemory() / 0x100000L + " M/ " + Runtime.getRuntime().totalMemory() / 0x100000L + " M"));
                    System.out.print("----------------------------------------");
                    System.out.println("----------------------------------------");
                    if (this.printError) {
                        log.error((Object)"Plugin installations fails", (Throwable)e);
                    } else {
                        log.info((Object)"Plugin installations fails. Please, execute walkmod with -e to see the details");
                    }
                }
                throw new InvalidConfigurationException(e);
            }
            if (!error && this.verbose) {
                endTime = System.currentTimeMillis();
                double time = 0.0;
                if (endTime > startTime) {
                    time = (double)(endTime - startTime) / 1000.0;
                }
                String timeMsg = myFormatter.format(time);
                System.out.print("----------------------------------------");
                System.out.println("----------------------------------------");
                System.out.println();
                log.info((Object)"PLUGIN INSTALLATION COMPLETE");
                System.out.print("----------------------------------------");
                System.out.println("----------------------------------------");
                log.info((Object)("Total time: " + timeMsg + " seconds"));
                log.info((Object)("Finished at: " + df.format(new Date())));
                log.info((Object)("Final memory: " + Runtime.getRuntime().freeMemory() / 0x100000L + " M/ " + Runtime.getRuntime().totalMemory() / 0x100000L + " M"));
                System.out.print("----------------------------------------");
                System.out.println("----------------------------------------");
            }
        } else if (this.verbose) {
            log.error((Object)(this.cfg.getAbsolutePath() + " does not exist. The root directory of your project must contain a walkmod.xml"));
        } else {
            throw new WalkModException(this.cfg.getAbsolutePath() + " does not exist. The root directory of your project must contain a walkmod.xml");
        }
    }

    private void executeAllChains(ChainAdapterFactory apf, Configuration conf) {
        long startTime;
        Collection<ChainConfig> tcgfs = conf.getChainConfigs();
        if (this.verbose) {
            log.info((Object)"** STARTING TRANSFORMATIONS CHAINS **");
            System.out.print("----------------------------------------");
            System.out.println("----------------------------------------");
        }
        long endTime = startTime = System.currentTimeMillis();
        DecimalFormat myFormatter = new DecimalFormat("###.###");
        SimpleDateFormat df = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss", Locale.US);
        int num = 0;
        Iterator<ChainConfig> it = tcgfs.iterator();
        int pos = 1;
        while (it.hasNext()) {
            ChainConfig tcfg = it.next();
            if (tcgfs.size() > 1 && this.verbose) {
                String label = "";
                label = tcfg.getName() != null && !tcfg.getName().startsWith("chain_") ? "[" + tcfg.getName() + "](" + pos + "/" + tcgfs.size() + ") " : "(" + pos + "/" + tcgfs.size() + ")";
                log.info((Object)("TRANSFORMATION CHAIN " + label));
                System.out.println();
            }
            try {
                ChainAdapter ap = apf.createChainProxy(conf, tcfg.getName());
                ap.execute();
                num += ap.getWalkerAdapter().getWalker().getNumModifications();
                ++pos;
                if (!this.verbose) continue;
                if (Summary.getInstance().getWrittenFiles().isEmpty()) {
                    log.info((Object)"**No sources changed**");
                }
                if (!it.hasNext()) continue;
                System.out.println();
            }
            catch (Throwable e) {
                if (this.verbose) {
                    endTime = System.currentTimeMillis();
                    double time = 0.0;
                    if (endTime > startTime) {
                        time = (double)(endTime - startTime) / 1000.0;
                    }
                    String timeMsg = myFormatter.format(time);
                    if (num != 0) {
                        System.out.print("----------------------------------------");
                        System.out.println("----------------------------------------");
                    }
                    log.info((Object)"TRANSFORMATION CHAIN FAILS");
                    System.out.println();
                    System.out.print("----------------------------------------");
                    System.out.println("----------------------------------------");
                    log.info((Object)("Total time: " + timeMsg + " seconds"));
                    log.info((Object)("Finished at: " + df.format(new Date())));
                    log.info((Object)("Final memory: " + Runtime.getRuntime().freeMemory() / 0x100000L + " M/ " + Runtime.getRuntime().totalMemory() / 0x100000L + " M"));
                    System.out.print("----------------------------------------");
                    System.out.println("----------------------------------------");
                    log.info((Object)"Please, see the walkmod log file for details");
                    if (this.printError) {
                        log.error((Object)("TRANSFORMATION CHAIN (" + tcfg.getName() + ") FAILS"), e);
                    } else {
                        log.error((Object)("TRANSFORMATION CHAIN (" + tcfg.getName() + ") FAILS. Execute walkmod with -e to see the error details."));
                    }
                } else {
                    throw new WalkModException(e);
                }
                return;
            }
        }
        if (this.verbose) {
            endTime = System.currentTimeMillis();
            double time = 0.0;
            if (endTime > startTime) {
                time = (double)(endTime - startTime) / 1000.0;
            }
            String timeMsg = myFormatter.format(time);
            if (num != 0) {
                System.out.print("----------------------------------------");
                System.out.println("----------------------------------------");
            }
            System.out.println();
            log.info((Object)"TRANSFORMATION CHAIN SUCCESS");
            System.out.print("----------------------------------------");
            System.out.println("----------------------------------------");
            log.info((Object)("Total time: " + timeMsg + " seconds"));
            log.info((Object)("Finished at: " + df.format(new Date())));
            log.info((Object)("Final memory: " + Runtime.getRuntime().freeMemory() / 0x100000L + " M/ " + Runtime.getRuntime().totalMemory() / 0x100000L + " M"));
            log.info((Object)("Total modified files: " + num));
            System.out.print("----------------------------------------");
            System.out.println("----------------------------------------");
        }
    }

    private void executeChainAdapter(ChainAdapterFactory apf, Configuration conf, String name) {
        ChainAdapter ap = apf.createChainProxy(conf, name);
        if (ap == null) {
            if (this.verbose) {
                log.error((Object)("The chain " + name + " is not found"));
                System.out.print("----------------------------------------");
                System.out.println("----------------------------------------");
            }
        } else {
            long startTime;
            long endTime = startTime = System.currentTimeMillis();
            DecimalFormat myFormatter = new DecimalFormat("###.###");
            SimpleDateFormat df = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss", Locale.US);
            if (this.verbose) {
                log.info((Object)("** THE TRANSFORMATION CHAIN " + name + " STARTS **"));
                System.out.print("----------------------------------------");
                System.out.println("----------------------------------------");
            }
            int num = 0;
            try {
                ap.execute();
                num = ap.getWalkerAdapter().getWalker().getNumModifications();
                if (this.verbose) {
                    endTime = System.currentTimeMillis();
                    double time = 0.0;
                    if (endTime > startTime) {
                        time = (double)(endTime - startTime) / 1000.0;
                    }
                    String timeMsg = myFormatter.format(time);
                    if (num != 0) {
                        System.out.print("----------------------------------------");
                        System.out.println("----------------------------------------");
                    } else if (Summary.getInstance().getWrittenFiles().isEmpty()) {
                        log.info((Object)"**No sources changed**");
                    }
                    System.out.println();
                    log.info((Object)"TRANSFORMATION CHAIN SUCCESS");
                    System.out.print("----------------------------------------");
                    System.out.println("----------------------------------------");
                    log.info((Object)("Total time: " + timeMsg + " seconds"));
                    log.info((Object)("Finished at: " + df.format(new Date())));
                    log.info((Object)("Final memory: " + Runtime.getRuntime().freeMemory() / 0x100000L + " M/ " + Runtime.getRuntime().totalMemory() / 0x100000L + " M"));
                    if (ap.getWalkerAdapter().getWalker().reportChanges()) {
                        log.info((Object)("Total modified files: " + num));
                    }
                    System.out.print("----------------------------------------");
                    System.out.println("----------------------------------------");
                }
            }
            catch (Throwable e) {
                if (this.verbose) {
                    endTime = System.currentTimeMillis();
                    double time = 0.0;
                    if (endTime > startTime) {
                        time = (double)(endTime - startTime) / 1000.0;
                    }
                    String timeMsg = myFormatter.format(time);
                    if (num != 0) {
                        System.out.print("----------------------------------------");
                        System.out.println("----------------------------------------");
                    }
                    log.info((Object)"TRANSFORMATION CHAIN FAILS");
                    System.out.println();
                    System.out.print("----------------------------------------");
                    System.out.println("----------------------------------------");
                    log.info((Object)("Total time: " + timeMsg + " seconds"));
                    log.info((Object)("Finished at: " + df.format(new Date())));
                    log.info((Object)("Final memory: " + Runtime.getRuntime().freeMemory() / 0x100000L + " M/ " + Runtime.getRuntime().totalMemory() / 0x100000L + " M"));
                    System.out.print("----------------------------------------");
                    System.out.println("----------------------------------------");
                    log.info((Object)"Please, see the walkmod log file for details");
                    if (this.printError) {
                        log.error((Object)("TRANSFORMATION CHAIN (" + name + ") FAILS"), e);
                    } else {
                        log.error((Object)("TRANSFORMATION CHAIN (" + name + ") FAILS. Execute walkmod with -e to see the error details."));
                    }
                } else {
                    throw new WalkModException(e);
                }
                return;
            }
        }
    }
}

