/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.commentscleaner.visitors;

import java.beans.Statement;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.apache.log4j.Logger;
import org.walkmod.javalang.ASTManager;
import org.walkmod.javalang.ParseException;
import org.walkmod.javalang.ast.BlockComment;
import org.walkmod.javalang.ast.Comment;
import org.walkmod.javalang.ast.CompilationUnit;
import org.walkmod.javalang.ast.LineComment;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.visitors.VoidVisitorAdapter;

public class CommentsCleanerVisitor<T>
extends VoidVisitorAdapter<T> {
    private static final Logger log = Logger.getLogger(CommentsCleanerVisitor.class);

    public void visit(CompilationUnit cu, T ctx) {
        List comments = cu.getComments();
        if (comments != null) {
            List finalComments = new LinkedList<Comment>();
            Stack toogleComments = new Stack();
            Comment lastLineComment = null;
            for (Comment comment : comments) {
                if (comment instanceof BlockComment) {
                    if (this.requiresToDelete(comment.getContent())) continue;
                    finalComments.add(comment);
                    continue;
                }
                if (comment instanceof LineComment) {
                    if (lastLineComment == null || lastLineComment.getBeginLine() != comment.getBeginLine() - 1) {
                        LinkedList<Comment> list = new LinkedList<Comment>();
                        list.add(comment);
                        toogleComments.push(list);
                    } else {
                        List toogleComment = (List)toogleComments.peek();
                        toogleComment.add(comment);
                    }
                    lastLineComment = comment;
                    continue;
                }
                finalComments.add(comment);
            }
            for (List list : toogleComments) {
                if (this.requiresToDelete(list)) continue;
                if (!finalComments.isEmpty()) {
                    Comment firstComment = (Comment)list.get(0);
                    boolean added = false;
                    LinkedList<Comment> accum = new LinkedList<Comment>();
                    for (Comment addedComment : finalComments) {
                        if (addedComment.isPreviousThan((Node)firstComment)) {
                            accum.add(addedComment);
                            continue;
                        }
                        if (!added) {
                            accum.addAll(list);
                            added = true;
                        }
                        accum.add(addedComment);
                    }
                    if (!added) {
                        accum.addAll(list);
                    }
                    finalComments = accum;
                    continue;
                }
                finalComments = list;
            }
            cu.setComments(finalComments);
        }
    }

    private boolean requiresToDelete(List<Comment> comments) {
        String code = "";
        for (Comment c : comments) {
            code = code + c.getContent();
        }
        return this.requiresToDelete(code);
    }

    private boolean requiresToDelete(String code) {
        try {
            if (!code.startsWith("{")) {
                code = "{" + code + "}";
            }
            ASTManager.parse(Statement.class, (String)code);
            log.debug((Object)("Deleting " + code));
            return true;
        }
        catch (ParseException parseException) {
            return false;
        }
    }
}

