/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.junit4git.junit5;

import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.walkmod.junit4git.core.JUnitEventType;
import org.walkmod.junit4git.core.TestsReportClient;

public class Junit5GitListener
implements TestExecutionListener {
    private final TestsReportClient client = new TestsReportClient();
    private TestPlan plan;

    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.plan = testPlan;
    }

    private String getClassName(TestIdentifier testIdentifier) {
        return this.plan.getParent(testIdentifier).flatMap(TestIdentifier::getSource).filter(ClassSource.class::isInstance).map(ClassSource.class::cast).map(ClassSource::getClassName).orElseThrow(() -> new IllegalStateException("Invalid test class name"));
    }

    private String getMethodName(TestIdentifier testIdentifier) {
        return testIdentifier.getSource().filter(MethodSource.class::isInstance).map(MethodSource.class::cast).map(MethodSource::getMethodName).orElseThrow(() -> new IllegalStateException("Invalid test method name"));
    }

    public void executionStarted(TestIdentifier testIdentifier) {
        if (testIdentifier.isTest()) {
            this.client.sendRequestToClassLoggerAgent(this.getClassName(testIdentifier), this.getMethodName(testIdentifier), JUnitEventType.START.getName());
        }
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        if (testIdentifier.isTest()) {
            this.client.sendRequestToClassLoggerAgent(this.getClassName(testIdentifier), this.getMethodName(testIdentifier), JUnitEventType.STOP.getName());
        }
    }
}

