/*
 * Decompiled with CFR 0.152.
 */
package org.vootoo.server.netty;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.concurrent.RejectedExecutionException;
import org.apache.solr.core.CoreContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vootoo.client.netty.ProtobufRequestGetter;
import org.vootoo.client.netty.protocol.SolrProtocol;
import org.vootoo.common.VootooException;
import org.vootoo.server.RequestExecutor;
import org.vootoo.server.Vootoo;
import org.vootoo.server.netty.ProtobufResponseSetter;
import org.vootoo.server.netty.SolrRequestRunner;

public class SolrServerHandler
extends SimpleChannelInboundHandler<SolrProtocol.SolrRequest> {
    private static final Logger logger = LoggerFactory.getLogger(SolrServerHandler.class);
    private final CoreContainer coreContainer;
    private final RequestExecutor queryExecutor;
    private final RequestExecutor updateExecutor;

    public SolrServerHandler(CoreContainer coreContainer, RequestExecutor queryExecutor, RequestExecutor updateExecutor) {
        this.coreContainer = coreContainer;
        this.queryExecutor = queryExecutor;
        this.updateExecutor = updateExecutor;
    }

    protected void channelRead0(ChannelHandlerContext ctx, SolrProtocol.SolrRequest solrRequest) throws Exception {
        NettySolrRequestRunner solrTask = new NettySolrRequestRunner(ctx, new ProtobufRequestGetter(solrRequest));
        try {
            if (Vootoo.isUpdateRequest(solrRequest.getPath())) {
                solrTask.setIsUpdate(true);
                this.updateExecutor.submitTask(solrTask, SolrProtocol.SolrResponse.class);
            } else {
                solrTask.setIsUpdate(false);
                this.queryExecutor.submitTask(solrTask, SolrProtocol.SolrResponse.class);
            }
        }
        catch (RejectedExecutionException e) {
            solrTask.logRejected();
            ProtobufResponseSetter responeSetter = new ProtobufResponseSetter(solrRequest.getRid());
            responeSetter.addError(VootooException.VootooErrorCode.TOO_MANY_REQUESTS.code, "RequestExecutor thread pool is full, server is too busy!");
            ctx.writeAndFlush((Object)responeSetter.buildProtocolResponse());
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        logger.debug("channelReadComplete, channel={}", (Object)ctx.channel());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        logger.warn("Netty Channel Handler Exception channel=" + ctx.channel(), cause);
        ctx.close();
    }

    private class NettySolrRequestRunner
    extends SolrRequestRunner {
        private final ChannelHandlerContext ctx;

        public NettySolrRequestRunner(ChannelHandlerContext ctx, ProtobufRequestGetter solrRequest) {
            super(SolrServerHandler.this.coreContainer, solrRequest);
            this.ctx = ctx;
        }

        @Override
        protected String getSocketAddress() {
            return this.ctx.channel().remoteAddress().toString();
        }

        @Override
        protected void writeProtocolResponse(SolrProtocol.SolrResponse protocolResponse) {
            this.ctx.writeAndFlush((Object)protocolResponse);
        }
    }
}

