/*
 * Decompiled with CFR 0.152.
 */
package org.vootoo.server.netty;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.CoreContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.vootoo.RequestGetter;
import org.vootoo.client.netty.ProtobufRequestGetter;
import org.vootoo.client.netty.protocol.SolrProtocol;
import org.vootoo.common.VootooException;
import org.vootoo.server.RequestProcesser;
import org.vootoo.server.Vootoo;
import org.vootoo.server.netty.ProtobufResponseSetter;

public abstract class SolrRequestRunner
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(SolrRequestRunner.class);
    private static final Logger queryLogger = LoggerFactory.getLogger((String)Vootoo.requestLogName("Query"));
    private static final Logger updateLogger = LoggerFactory.getLogger((String)Vootoo.requestLogName("Update"));
    private static final Logger rejectedLogger = LoggerFactory.getLogger((String)Vootoo.requestLogName("Rejected"));
    private CoreContainer coreContainer;
    private ProtobufRequestGetter solrRequest;
    private boolean isUpdate = false;
    private int queryDefaultTimeout = 2000;
    protected static final Set<String> toLogNames;

    public SolrRequestRunner(CoreContainer coreContainer, ProtobufRequestGetter solrRequest) {
        this.coreContainer = coreContainer;
        this.solrRequest = solrRequest;
    }

    protected void putMDC() {
        MDC.put((String)"rid", (String)String.valueOf(this.solrRequest.getRid()));
        MDC.put((String)"request_size", (String)String.valueOf(this.solrRequest.requestSize()));
        MDC.put((String)"request_path", (String)this.solrRequest.getPath());
    }

    protected void putMDCWithExecuteTime(long executeTime) {
        MDC.put((String)"execute_time", (String)String.valueOf(executeTime));
    }

    protected void putMDCWithWaitTime(long waitTime) {
        MDC.put((String)"wait_time", (String)String.valueOf(waitTime));
    }

    protected void putMDCWithRemoteAddress(String remoteAddress) {
        MDC.put((String)"remote_address", (String)remoteAddress);
    }

    protected void clearMDC() {
        MDC.remove((String)"rid");
        MDC.remove((String)"request_size");
        MDC.remove((String)"request_path");
        MDC.remove((String)"execute_time");
        MDC.remove((String)"wait_time");
        MDC.remove((String)"remote_address");
    }

    protected abstract String getSocketAddress();

    @Override
    public void run() {
        this.clearMDC();
        this.putMDC();
        this.putMDCWithRemoteAddress(this.getSocketAddress());
        ProtobufResponseSetter responseSetter = new ProtobufResponseSetter(this.solrRequest.getRid());
        try {
            this.handleRequest(responseSetter, this.solrRequest);
        }
        catch (Throwable t) {
            responseSetter.addError(t);
        }
        finally {
            this.writeProtocolResponse(responseSetter.buildProtocolResponse());
        }
    }

    protected abstract void writeProtocolResponse(SolrProtocol.SolrResponse var1);

    protected void handleRequest(ProtobufResponseSetter responeSetter, ProtobufRequestGetter solrRequest) {
        long waitTime = solrRequest.useTime();
        this.putMDCWithWaitTime(waitTime);
        Logger myLogger = this.isUpdate ? updateLogger : queryLogger;
        SolrParams solrParams = solrRequest.getSolrParams();
        int timeout = solrParams.getInt("timeAllowed", this.queryDefaultTimeout);
        if (waitTime > (long)timeout) {
            myLogger.warn("tip={} params={{}}", (Object)"Timeout_In_Queue", (Object)solrParams);
            throw new VootooException(VootooException.VootooErrorCode.TIMEOUT, "timeout stay in RequestQueue");
        }
        if (myLogger.isDebugEnabled()) {
            myLogger.debug("tip={} params={{}}", (Object)"Start_Execute", (Object)solrRequest.getSolrParams());
        }
        RequestProcesser requestHandler = new RequestProcesser(this.coreContainer, responeSetter);
        long st = System.currentTimeMillis();
        requestHandler.handleRequest((RequestGetter)solrRequest);
        long ut = System.currentTimeMillis() - st;
        this.putMDCWithExecuteTime(ut);
        if (responeSetter.getSolrQueryResponse() != null && responeSetter.getSolrQueryResponse().getToLog().size() > 0) {
            NamedList myToLog = responeSetter.getSolrQueryResponse().getToLog();
            String plog = this.toLogString((NamedList<Object>)myToLog);
            myLogger.info("{}", (Object)plog);
        } else {
            myLogger.info("params={{}}", (Object)solrParams);
        }
    }

    protected String toLogString(NamedList<Object> toLog) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < toLog.size(); ++i) {
            String name = toLog.getName(i);
            if (!toLogNames.contains(name)) continue;
            Object val = toLog.getVal(i);
            if (name != null) {
                sb.append(name).append('=');
            }
            sb.append(val).append(' ');
        }
        return sb.toString();
    }

    protected void logRejected() {
        this.clearMDC();
        this.putMDC();
        this.putMDCWithRemoteAddress(this.getSocketAddress());
        rejectedLogger.warn("tip={} params={{}}", (Object)"Request_Rejected", (Object)this.solrRequest.getSolrParams());
    }

    public void setIsUpdate(boolean isUpdate) {
        this.isUpdate = isUpdate;
    }

    static {
        HashSet<String> logNames = new HashSet<String>();
        logNames.add("params");
        logNames.add("hits");
        logNames.add("status");
        logNames.add("QTime");
        toLogNames = Collections.unmodifiableSet(logNames);
    }
}

