/*
 * Decompiled with CFR 0.152.
 */
package org.vootoo.server.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import org.apache.solr.core.CoreContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vootoo.server.ExecutorConfig;
import org.vootoo.server.RequestExecutor;
import org.vootoo.server.netty.ChannelHandlerConfigs;
import org.vootoo.server.netty.SolrServerChannelInitializer;

public class SolrNettyServer {
    private static final Logger logger = LoggerFactory.getLogger(SolrNettyServer.class);
    private final int port;
    private final CoreContainer coreContainer;
    private RequestExecutor queryExecutor;
    private RequestExecutor updateExecutor;
    protected ExecutorConfig queryConfig = ExecutorConfig.createDefault().setName("query-executor");
    protected ExecutorConfig updateConfig = ExecutorConfig.createDefault().setName("update-executor").setThreadNum(40);
    private int bossWorkerNum = Math.max(1, Runtime.getRuntime().availableProcessors() - 1);
    private int ioWorkerNum = Runtime.getRuntime().availableProcessors() * 2;
    protected ChannelHandlerConfigs handlerConfigs = new ChannelHandlerConfigs();
    protected volatile Channel serverChannel;
    protected Thread asyncNettyRunner;

    public SolrNettyServer(CoreContainer cores, int port) {
        this.coreContainer = cores;
        this.port = port;
    }

    public void startServer(boolean sync) throws Exception {
        if (sync) {
            this.startNetty();
        } else {
            this.asyncNettyRunner = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        SolrNettyServer.this.startNetty();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }, "async-netty-runner");
            this.asyncNettyRunner.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startNetty() throws Exception {
        logger.info("netty server starting port={} ...", (Object)this.port);
        this.queryExecutor = new RequestExecutor(this.queryConfig);
        this.updateExecutor = new RequestExecutor(this.updateConfig);
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(this.bossWorkerNum);
        NioEventLoopGroup workerGroup = new NioEventLoopGroup(this.ioWorkerNum);
        try {
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)b.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)new SolrServerChannelInitializer(this.coreContainer, this.handlerConfigs, this.queryExecutor, this.updateExecutor));
            ChannelFuture f = b.bind(this.port).sync();
            logger.info("netty server started port={}", (Object)this.port);
            this.serverChannel = f.channel();
            this.serverChannel.closeFuture().sync();
        }
        finally {
            bossGroup.shutdownGracefully();
            workerGroup.shutdownGracefully();
            bossGroup.terminationFuture().sync();
            workerGroup.terminationFuture().sync();
        }
    }

    public void stopServer() throws Exception {
        if (this.serverChannel != null) {
            logger.info("server channel closing ...");
            this.serverChannel.close();
            logger.info("server channel is closed");
        }
    }

    public int getBossWorkerNum() {
        return this.bossWorkerNum;
    }

    public void setBossWorkerNum(int bossWorkerNum) {
        this.bossWorkerNum = bossWorkerNum;
    }

    public int getIoWorkerNum() {
        return this.ioWorkerNum;
    }

    public void setIoWorkerNum(int ioWorkerNum) {
        this.ioWorkerNum = ioWorkerNum;
    }

    public ExecutorConfig getQueryConfig() {
        return this.queryConfig;
    }

    public void setQueryConfig(ExecutorConfig queryConfig) {
        this.queryConfig = queryConfig;
    }

    public ExecutorConfig getUpdateConfig() {
        return this.updateConfig;
    }

    public void setUpdateConfig(ExecutorConfig updateConfig) {
        this.updateConfig = updateConfig;
    }
}

