/*
 * Decompiled with CFR 0.152.
 */
package org.vootoo.server;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.solr.util.DefaultSolrThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vootoo.server.ExecutorConfig;

public class RequestExecutor {
    private static final Logger logger = LoggerFactory.getLogger(RequestExecutor.class);
    private final ExecutorConfig config;
    private final ThreadPoolExecutor requestExecutor;
    private ListeningExecutorService executorService;

    public RequestExecutor(String name, int threadNum, int maxWaitTask) {
        this(ExecutorConfig.createDefault().setName(name).setThreadNum(threadNum).setMaxWaitTask(maxWaitTask));
    }

    public RequestExecutor(ExecutorConfig config) {
        this.config = config;
        this.requestExecutor = new ThreadPoolExecutor(config.getThreadNum(), config.getThreadNum(), (long)config.getThreadKeepAliveMinute(), TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(config.getMaxWaitTask()), (ThreadFactory)new DefaultSolrThreadFactory(config.getName()));
        this.executorService = MoreExecutors.listeningDecorator((ExecutorService)this.requestExecutor);
    }

    public void changeThreadNum(int newThreadNum) {
        if (this.requestExecutor.getMaximumPoolSize() != newThreadNum) {
            logger.info("{} RequestExecutor thread number expect from {} to {}", new Object[]{this.config.getName(), this.config.getThreadNum(), newThreadNum});
            if (this.requestExecutor.getMaximumPoolSize() > newThreadNum) {
                this.requestExecutor.setCorePoolSize(newThreadNum);
                this.requestExecutor.setMaximumPoolSize(newThreadNum);
            } else if (this.requestExecutor.getMaximumPoolSize() < newThreadNum) {
                this.requestExecutor.setMaximumPoolSize(newThreadNum);
                this.requestExecutor.setCorePoolSize(newThreadNum);
            }
            this.config.setThreadNum(newThreadNum);
        } else {
            logger.info("{} RequestExecutor thread number expect={} is not change", new Object[]{this.config.getName(), newThreadNum});
        }
    }

    public boolean shutdownAndAwaitTermination(long timeout, TimeUnit unit) {
        return MoreExecutors.shutdownAndAwaitTermination((ExecutorService)this.executorService, (long)timeout, (TimeUnit)unit);
    }

    public <T> ListenableFuture<T> submitTask(Callable<T> task) {
        return this.executorService.submit(task);
    }

    public <T> ListenableFuture<T> submitTask(Runnable task, T result) {
        return this.executorService.submit(task, result);
    }
}

