/*
 * Decompiled with CFR 0.152.
 */
package org.vootoo.server;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.SolrQueryRequest;

public class Vootoo {
    public static final String UPDATE_PATH = "/update";
    public static final String UPDATE_PREFIX = "/update/";
    public static final String MDC_NAME_RID = "rid";
    public static final String MDC_NAME_REQUEST_SIZE = "request_size";
    public static final String MDC_NAME_REQUEST_PATH = "request_path";
    public static final String MDC_NAME_EXECUTE_TIME = "execute_time";
    public static final String MDC_NAME_WAIT_TIME = "wait_time";
    public static final String MDC_NAME_REMOTE_ADDRESS = "remote_address";

    public static boolean isUpdateRequest(String path) {
        if (StringUtils.isBlank((String)path)) {
            return false;
        }
        return UPDATE_PATH.equals(path) || path.startsWith(UPDATE_PREFIX);
    }

    public static String requestLogName(String suffix) {
        String mySuffix = suffix == null ? "request" : "request." + suffix;
        return Vootoo.class.getPackage().getName() + "." + mySuffix;
    }

    public static Map<String, Integer> checkStateIsValid(CoreContainer cores, String stateVer) {
        HashMap<String, Integer> result = null;
        String[] pairs = null;
        if (stateVer != null && !stateVer.isEmpty() && cores.isZooKeeperAware()) {
            for (String pair : pairs = StringUtils.split((String)stateVer, (char)'|')) {
                Integer status;
                String[] pcs = StringUtils.split((String)pair, (char)':');
                if (pcs.length != 2 || pcs[0].isEmpty() || pcs[1].isEmpty() || (status = cores.getZkController().getZkStateReader().compareStateVersions(pcs[0], Integer.parseInt(pcs[1]))) == null) continue;
                if (result == null) {
                    result = new HashMap<String, Integer>();
                }
                result.put(pcs[0], status);
            }
        }
        return result;
    }

    public static void processAliases(SolrQueryRequest solrReq, Aliases aliases, List<String> collectionsList) {
        String collection = solrReq.getParams().get("collection");
        if (collection != null) {
            collectionsList = StrUtils.splitSmart((String)collection, (String)",", (boolean)true);
        }
        if (collectionsList != null) {
            HashSet<String> newCollectionsList = new HashSet<String>(collectionsList.size());
            for (String col : collectionsList) {
                String al = aliases.getCollectionAlias(col);
                if (al != null) {
                    List aliasList = StrUtils.splitSmart((String)al, (String)",", (boolean)true);
                    newCollectionsList.addAll(aliasList);
                    continue;
                }
                newCollectionsList.add(col);
            }
            if (newCollectionsList.size() > 0) {
                StringBuilder collectionString = new StringBuilder();
                Iterator it = newCollectionsList.iterator();
                int sz = newCollectionsList.size();
                for (int i = 0; i < sz; ++i) {
                    collectionString.append((String)it.next());
                    if (i >= newCollectionsList.size() - 1) continue;
                    collectionString.append(",");
                }
                ModifiableSolrParams params = new ModifiableSolrParams(solrReq.getParams());
                params.set("collection", new String[]{collectionString.toString()});
                solrReq.setParams((SolrParams)params);
            }
        }
    }

    public static SolrCore getCoreByCollection(CoreContainer cores, String corename) {
        ZkStateReader zkStateReader = cores.getZkController().getZkStateReader();
        ClusterState clusterState = zkStateReader.getClusterState();
        Map slices = clusterState.getActiveSlicesMap(corename);
        if (slices == null) {
            return null;
        }
        Set entries = slices.entrySet();
        SolrCore core = null;
        block0: for (Map.Entry entry : entries) {
            Replica leaderProps = clusterState.getLeader(corename, (String)entry.getKey());
            if (leaderProps != null) {
                core = Vootoo.checkProps(cores, (ZkNodeProps)leaderProps);
            }
            if (core != null) break;
            Map shards = ((Slice)entry.getValue()).getReplicasMap();
            Set shardEntries = shards.entrySet();
            for (Map.Entry shardEntry : shardEntries) {
                Replica zkProps = (Replica)shardEntry.getValue();
                core = Vootoo.checkProps(cores, (ZkNodeProps)zkProps);
                if (core == null) continue;
                break block0;
            }
        }
        return core;
    }

    public static SolrCore checkProps(CoreContainer cores, ZkNodeProps zkProps) {
        SolrCore core = null;
        if (cores.getZkController().getNodeName().equals(zkProps.getStr("node_name"))) {
            String corename = zkProps.getStr("core");
            core = cores.getCore(corename);
        }
        return core;
    }
}

