/*
 * Decompiled with CFR 0.152.
 */
package org.vootoo.server;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.RequestHandlers;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.ContentStreamHandlerBase;
import org.apache.solr.logging.MDCLoggingContext;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.QueryResponseWriterUtil;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.servlet.ResponseUtils;
import org.apache.solr.servlet.SolrRequestParsers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vootoo.RequestGetter;
import org.vootoo.server.ResponseSetter;
import org.vootoo.server.Vootoo;

public class RequestProcesser {
    private static final Logger logger = LoggerFactory.getLogger(RequestProcesser.class);
    private final CoreContainer cores;
    private final ResponseSetter responseSetter;
    private SolrCore core = null;
    private SolrQueryRequest solrReq = null;
    private Aliases aliases = null;
    private Map<String, Integer> invalidStates = null;
    SolrParams solrParams;

    public RequestProcesser(CoreContainer cores, ResponseSetter responseSetter) {
        this.cores = cores;
        this.responseSetter = responseSetter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(RequestGetter requestGetter) {
        MDCLoggingContext.reset();
        MDCLoggingContext.setNode((CoreContainer)this.cores);
        String path = requestGetter.getPath();
        this.solrParams = requestGetter.getSolrParams();
        SolrRequestHandler handler = null;
        String corename = "";
        String origCorename = null;
        try {
            int idx;
            String alternate = this.cores.getManagementPath();
            if (alternate != null && path.startsWith(alternate)) {
                path = path.substring(0, alternate.length());
            }
            if ((idx = path.indexOf(58)) > 0) {
                path = path.substring(0, idx);
            }
            boolean usingAliases = false;
            List collectionsList = null;
            handler = this.cores.getRequestHandler(path);
            if (handler != null) {
                this.solrReq = this.parseSolrQueryRequest(SolrRequestParsers.DEFAULT, requestGetter);
                this.handleAdminRequest(handler, this.solrReq);
                return;
            }
            idx = path.indexOf("/", 1);
            if (idx > 1) {
                corename = path.substring(1, idx);
                if (this.cores.isZooKeeperAware()) {
                    origCorename = corename;
                    ZkStateReader reader = this.cores.getZkController().getZkStateReader();
                    this.aliases = reader.getAliases();
                    if (this.aliases != null && this.aliases.collectionAliasSize() > 0) {
                        usingAliases = true;
                        String alias = this.aliases.getCollectionAlias(corename);
                        if (alias != null) {
                            collectionsList = StrUtils.splitSmart((String)alias, (String)",", (boolean)true);
                            corename = (String)collectionsList.get(0);
                        }
                    }
                }
                this.core = this.cores.getCore(corename);
                if (this.core != null) {
                    path = path.substring(idx);
                }
            }
            if (this.core == null && StringUtils.isNotBlank((String)requestGetter.getCollection())) {
                corename = requestGetter.getCollection();
                this.core = this.cores.getCore(corename);
            }
            if (this.core == null && !this.cores.isZooKeeperAware()) {
                this.core = this.cores.getCore("");
            }
            if (this.core == null && this.cores.isZooKeeperAware()) {
                this.core = Vootoo.getCoreByCollection(this.cores, corename);
                if (this.core != null) {
                    path = path.substring(idx);
                }
                if (this.core == null) {
                    this.core = this.cores.getCore("");
                    if (this.core != null) {
                        // empty if block
                    }
                }
            }
            if (this.core != null) {
                MDCLoggingContext.setCore((SolrCore)this.core);
                SolrConfig config = this.core.getSolrConfig();
                SolrRequestParsers parser = config.getRequestParsers();
                if (handler == null && path.length() > 1) {
                    handler = this.core.getRequestHandler(path);
                    if (handler == null && (path.equals("/schema") || path.startsWith("/schema/"))) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "unsupport /schema/**, use http solr");
                    }
                    if (handler == null && parser.isHandleSelect() && ("/select".equals(path) || "/select/".equals(path))) {
                        this.solrReq = this.parseSolrQueryRequest(parser, requestGetter);
                        this.invalidStates = Vootoo.checkStateIsValid(this.cores, this.solrReq.getParams().get("_stateVer_"));
                        String qt = this.solrReq.getParams().get("qt");
                        handler = this.core.getRequestHandler(qt);
                        if (handler == null) {
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "unknown handler: " + qt);
                        }
                        if (qt != null && qt.startsWith("/") && handler instanceof ContentStreamHandlerBase) {
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid Request Handler ('qt').  Do not use /select to access: " + qt);
                        }
                    }
                }
                if (handler != null) {
                    if (this.solrReq == null) {
                        this.solrReq = this.parseSolrQueryRequest(parser, requestGetter);
                    }
                    if (usingAliases) {
                        Vootoo.processAliases(this.solrReq, this.aliases, collectionsList);
                    }
                    SolrQueryResponse solrRsp = new SolrQueryResponse();
                    SolrRequestInfo.setRequestInfo((SolrRequestInfo)new SolrRequestInfo(this.solrReq, solrRsp));
                    this.execute(handler, this.solrReq, solrRsp);
                    QueryResponseWriter responseWriter = this.core.getQueryResponseWriter(this.solrReq);
                    if (this.invalidStates != null) {
                        this.solrReq.getContext().put("_stateVer_", this.invalidStates);
                    }
                    this.writeResponse(solrRsp, responseWriter, this.solrReq);
                    return;
                }
            }
            try {
                logger.debug("no handler or core retrieved for {}, follow through...", (Object)path);
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "no handler or core retrieved for " + path);
            }
            catch (Throwable ex) {
                this.sendError(this.core, this.solrReq, ex);
                for (Throwable t = ex; t != null; t = t.getCause()) {
                    if (!(t instanceof Error)) continue;
                    if (t != ex) {
                        logger.error("An Error was wrapped in another exception - please report complete stacktrace on SOLR-6161", ex);
                    }
                    throw (Error)t;
                }
                return;
            }
        }
        finally {
            try {
                if (this.solrReq != null) {
                    logger.debug("Closing out SolrRequest: {}", (Object)this.solrReq);
                    this.solrReq.close();
                }
            }
            finally {
                try {
                    if (this.core != null) {
                        this.core.close();
                    }
                }
                finally {
                    SolrRequestInfo.clearRequestInfo();
                }
            }
            MDCLoggingContext.clear();
        }
    }

    protected void execute(SolrRequestHandler handler, SolrQueryRequest sreq, SolrQueryResponse rsp) {
        sreq.getContext().put("webapp", "vootoo");
        sreq.getCore().execute(handler, sreq, rsp);
    }

    protected void writeResponse(SolrQueryResponse solrRsp, QueryResponseWriter responseWriter, SolrQueryRequest solrReq) throws IOException {
        String ct;
        Object invalidStates = solrReq.getContext().get("_stateVer_");
        if (invalidStates != null) {
            solrRsp.add("_stateVer_", invalidStates);
        }
        if (null != (ct = responseWriter.getContentType(solrReq, solrRsp))) {
            this.responseSetter.setContentType(ct);
        }
        if (solrRsp.getException() != null) {
            SimpleOrderedMap info = new SimpleOrderedMap();
            int code = ResponseUtils.getErrorInfo((Throwable)solrRsp.getException(), (NamedList)info, (Logger)logger);
            this.responseSetter.setSolrResponseException(code, (NamedList)info);
        }
        QueryResponseWriterUtil.writeQueryResponse((OutputStream)this.responseSetter.getResponseOutputStream(), (QueryResponseWriter)responseWriter, (SolrQueryRequest)solrReq, (SolrQueryResponse)solrRsp, (String)ct);
        this.responseSetter.writeQueryResponseComplete(solrRsp);
    }

    protected void sendError(SolrCore core, SolrQueryRequest req, Throwable ex) {
        this.responseSetter.addError(ex);
    }

    protected SolrQueryRequest parseSolrQueryRequest(SolrRequestParsers parser, RequestGetter requestGetter) throws Exception {
        ArrayList streams = new ArrayList(1);
        if (requestGetter.getContentStreams() != null && requestGetter.getContentStreams().size() > 0) {
            streams.addAll(requestGetter.getContentStreams());
        }
        SolrQueryRequest sreq = parser.buildRequestFrom(this.core, requestGetter.getSolrParams(), streams);
        sreq.getContext().put("path", RequestHandlers.normalize((String)requestGetter.getPath()));
        return sreq;
    }

    protected void handleAdminRequest(SolrRequestHandler handler, SolrQueryRequest solrReq) throws IOException {
        QueryResponseWriter respWriter;
        SolrQueryResponse solrResp = new SolrQueryResponse();
        SolrCore.preDecorateResponse((SolrQueryRequest)solrReq, (SolrQueryResponse)solrResp);
        handler.handleRequest(solrReq, solrResp);
        SolrCore.postDecorateResponse((SolrRequestHandler)handler, (SolrQueryRequest)solrReq, (SolrQueryResponse)solrResp);
        if (logger.isInfoEnabled() && solrResp.getToLog().size() > 0) {
            logger.info(solrResp.getToLogAsString("[admin] "));
        }
        if ((respWriter = (QueryResponseWriter)SolrCore.DEFAULT_RESPONSE_WRITERS.get(solrReq.getParams().get("wt"))) == null) {
            respWriter = (QueryResponseWriter)SolrCore.DEFAULT_RESPONSE_WRITERS.get("standard");
        }
        this.writeResponse(solrResp, respWriter, solrReq);
    }
}

