/*
 * Decompiled with CFR 0.152.
 */
package org.vootoo.client.netty;

import com.google.protobuf.ByteString;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Iterator;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.ContentStreamBase;
import org.apache.solr.common.util.JavaBinCodec;
import org.apache.solr.common.util.NamedList;

public class NettyUtil {
    public static final Bootstrap DEFAULT_BOOTSTRAP;

    public static NamedList<Object> bytesToParams(ByteString bs) throws IOException {
        if (bs == null) {
            return null;
        }
        return (NamedList)new JavaBinCodec().unmarshal(bs.newInput());
    }

    public static SolrParams fromString(String params) {
        String[] kvs;
        ModifiableSolrParams solrParams = new ModifiableSolrParams();
        for (String kv : kvs = params.split("&")) {
            int idx = kv.indexOf("=");
            if (idx <= 0 || idx >= kv.length() - 1) continue;
            try {
                solrParams.add(kv.substring(0, idx), new String[]{URLDecoder.decode(kv.substring(idx + 1, kv.length()), "utf-8")});
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return solrParams;
    }

    public static ByteString formSolrParams(SolrParams solrParams) {
        return ByteString.copyFromUtf8((String)NettyUtil.solrParamsToString(solrParams, "&"));
    }

    public static String solrParamsToString(SolrParams solrParams, String joinStr) {
        StringBuilder sb = new StringBuilder(128);
        Iterator it = solrParams.getParameterNamesIterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            String[] values = solrParams.getParams(name);
            if (values == null) {
                sb.append(name);
                sb.append(joinStr);
                continue;
            }
            for (String v : values) {
                sb.append(name);
                sb.append('=');
                sb.append(v);
                sb.append(joinStr);
            }
        }
        if (sb.length() > joinStr.length()) {
            sb.setLength(sb.length() - joinStr.length());
        }
        return sb.toString();
    }

    public static ByteString readFrom(ContentStream stream) throws IOException {
        InputStream in = stream.getStream();
        return ByteString.readFrom((InputStream)in);
    }

    public static ContentStreamBase readFrom(ByteString bytes) {
        return new ContentStreamBase.ByteArrayStream(bytes.toByteArray(), "ByteString_ContentStream");
    }

    static {
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.group((EventLoopGroup)new NioEventLoopGroup(10));
        bootstrap.channel(NioSocketChannel.class);
        bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)2000);
        DEFAULT_BOOTSTRAP = bootstrap;
    }
}

