/*
 * Decompiled with CFR 0.152.
 */
package org.vootoo.common;

import java.util.concurrent.atomic.AtomicInteger;

public abstract class RefCount<Type> {
    protected final Type resource;
    protected final AtomicInteger refcount = new AtomicInteger();

    public RefCount(Type resource) {
        this.resource = resource;
    }

    public int getRefcount() {
        return this.refcount.get();
    }

    public final RefCount<Type> incref() {
        this.refcount.incrementAndGet();
        return this;
    }

    public final Type get() {
        return this.resource;
    }

    public void decref() {
        if (this.refcount.decrementAndGet() == 0) {
            this.close();
        }
    }

    protected abstract void close();

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.resource == null ? 0 : this.resource.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RefCount other = (RefCount)obj;
        return !(this.resource == null ? other.resource != null : !this.resource.equals(other.resource));
    }
}

