/*
 * Decompiled with CFR 0.152.
 */
package org.vootoo.client.netty.util;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.ContentStreamBase;
import org.apache.solr.common.util.NamedList;
import org.vootoo.client.netty.protocol.SolrProtocol;
import org.vootoo.client.netty.util.ProtobufContentStream;
import org.vootoo.common.VootooException;

public class ProtobufUtil {
    public static ModifiableSolrParams toSolrParams(SolrProtocol.SolrRequest request) {
        ModifiableSolrParams params = new ModifiableSolrParams();
        List<SolrProtocol.Param> paramsList = request.getParamList();
        if (paramsList != null) {
            for (SolrProtocol.Param param : paramsList) {
                List<String> vs = param.getValueList();
                if (vs == null) {
                    params.add(param.getKey(), null);
                    continue;
                }
                params.add(param.getKey(), vs.toArray(new String[vs.size()]));
            }
        }
        return params;
    }

    private static SolrProtocol.Param toProtobufParam(String key, String[] values) {
        SolrProtocol.Param.Builder builder = SolrProtocol.Param.newBuilder();
        builder.setKey(key);
        for (String v : values) {
            builder.addValue(v);
        }
        return builder.build();
    }

    public static List<SolrProtocol.Param> toProtobufParams(SolrParams solrParams) {
        ArrayList<SolrProtocol.Param> paramList;
        if (solrParams instanceof ModifiableSolrParams) {
            ModifiableSolrParams mps = (ModifiableSolrParams)solrParams;
            Map maps = mps.getMap();
            paramList = new ArrayList(maps.size());
            for (Map.Entry e : maps.entrySet()) {
                paramList.add(ProtobufUtil.toProtobufParam((String)e.getKey(), (String[])e.getValue()));
            }
        } else {
            paramList = new ArrayList<SolrProtocol.Param>();
            Iterator it = solrParams.getParameterNamesIterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                String[] values = solrParams.getParams(key);
                paramList.add(ProtobufUtil.toProtobufParam(key, values));
            }
        }
        return paramList;
    }

    public static Collection<ContentStream> toSolrContentStreams(SolrProtocol.SolrRequest request) {
        return Collections2.transform(request.getContentStreamList(), (Function)new Function<SolrProtocol.ContentStream, ContentStream>(){

            public ContentStream apply(SolrProtocol.ContentStream input) {
                return new ProtobufContentStream(input);
            }
        });
    }

    public static List<SolrProtocol.ContentStream> toProtobufContentStreams(Collection<ContentStream> contentStreams) {
        return Lists.transform((List)Lists.newArrayList(contentStreams), (Function)new Function<ContentStream, SolrProtocol.ContentStream>(){

            public SolrProtocol.ContentStream apply(ContentStream input) {
                String contentType;
                SolrProtocol.ContentStream.Builder stream = SolrProtocol.ContentStream.newBuilder();
                if (input.getName() != null) {
                    stream.setName(input.getName());
                }
                if ((contentType = input.getContentType()) == null) {
                    contentType = "application/octet-stream";
                }
                stream.setContentType(contentType);
                stream.setSourceInfo(input.getSourceInfo());
                stream.setSize(input.getSize());
                try {
                    stream.setStream(ByteString.readFrom((InputStream)input.getStream()));
                }
                catch (IOException e) {
                    throw new RuntimeException("ContentStream.getStream() exception", e);
                }
                return stream.build();
            }
        });
    }

    public static InputStream getSolrResponseInputStream(SolrProtocol.SolrResponse protocolResponse) {
        if (protocolResponse.hasResponseBody()) {
            return protocolResponse.getResponseBody().getBody().newInput();
        }
        return null;
    }

    public static String getResponseBodyCharset(SolrProtocol.SolrResponse protocolResponse) {
        SolrProtocol.ResponseBody responseBody;
        String charset = ContentStreamBase.DEFAULT_CHARSET;
        if (protocolResponse != null && (responseBody = protocolResponse.getResponseBody()) != null) {
            charset = ContentStreamBase.getCharsetFromContentType((String)responseBody.getContentType());
        }
        return charset;
    }

    protected static NamedList<String> toSolrExceptionMetadata(List<SolrProtocol.KeyValue> keyValues) {
        NamedList metadata = new NamedList();
        for (SolrProtocol.KeyValue kv : keyValues) {
            metadata.add(kv.getKey(), (Object)kv.getValue());
        }
        return metadata;
    }

    public static void fillErrorMetadata(SolrProtocol.ExceptionBody.Builder protocolSolrException, NamedList<String> errorMetadata) {
        if (errorMetadata != null) {
            for (Map.Entry next : errorMetadata) {
                SolrProtocol.KeyValue.Builder metaBuilder = SolrProtocol.KeyValue.newBuilder();
                metaBuilder.setKey((String)next.getKey());
                metaBuilder.setValue((String)next.getValue());
                protocolSolrException.addMetadata(metaBuilder);
            }
        }
    }

    public static int getErrorInfo(Throwable ex, SolrProtocol.ExceptionBody.Builder exceptionBody) {
        int code = 500;
        if (ex instanceof SolrException) {
            SolrException solrExc = (SolrException)ex;
            code = solrExc.code();
            ProtobufUtil.fillErrorMetadata(exceptionBody, (NamedList<String>)solrExc.getMetadata());
        }
        for (Throwable th = ex; th != null; th = th.getCause()) {
            String msg = th.getMessage();
            if (msg == null) continue;
            exceptionBody.setMessage(msg);
            break;
        }
        if (code == 500 || code < 100) {
            exceptionBody.setTrace(SolrException.toStr((Throwable)ex));
            if (code < 100) {
                code = 500;
            }
        }
        exceptionBody.setCode(code);
        return code;
    }

    public static VootooException toVootooException(SolrProtocol.ExceptionBody exceptionBody) {
        String msg = exceptionBody.getMessage();
        VootooException.VootooErrorCode vec = VootooException.VootooErrorCode.getErrorCode(exceptionBody.getCode());
        VootooException ve = new VootooException(vec, msg);
        if (vec == VootooException.VootooErrorCode.UNKNOWN) {
            ve.setUnknownCode(exceptionBody.getCode());
        }
        if (exceptionBody.getMetadataCount() > 0) {
            NamedList<String> metadata = ProtobufUtil.toSolrExceptionMetadata(exceptionBody.getMetadataList());
            ve.setMetadata(metadata);
        }
        if (exceptionBody.hasTrace()) {
            ve.setRemoteTrace(exceptionBody.getTrace());
        }
        return ve;
    }
}

