/*
 * Decompiled with CFR 0.152.
 */
package org.vootoo.client.netty.util;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.ContentStreamBase;
import org.vootoo.client.netty.protocol.SolrProtocol;

public class ProtobufContentStream
implements ContentStream {
    private final SolrProtocol.ContentStream contentStream;

    public ProtobufContentStream(SolrProtocol.ContentStream contentStream) {
        this.contentStream = contentStream;
    }

    public String getName() {
        return this.contentStream.getName();
    }

    public String getSourceInfo() {
        return this.contentStream.getSourceInfo();
    }

    public String getContentType() {
        return this.contentStream.getContentType();
    }

    public Long getSize() {
        return this.contentStream.getSize();
    }

    public InputStream getStream() throws IOException {
        ByteString stream = this.contentStream.getStream();
        if (stream == null) {
            throw new IOException("ProtobufContentStream not found stream!");
        }
        return stream.newInput();
    }

    public Reader getReader() throws IOException {
        String charset = ContentStreamBase.getCharsetFromContentType((String)this.getContentType());
        return charset == null ? new InputStreamReader(this.getStream(), ContentStreamBase.DEFAULT_CHARSET) : new InputStreamReader(this.getStream(), charset);
    }
}

