/*
 * Decompiled with CFR 0.152.
 */
package org.vootoo.client.netty;

import com.google.protobuf.MessageLite;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.LengthFieldPrepender;
import io.netty.handler.codec.protobuf.ProtobufDecoder;
import io.netty.handler.codec.protobuf.ProtobufEncoder;
import java.net.SocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vootoo.client.netty.HandlerConfig;
import org.vootoo.client.netty.ResponsePromiseContainer;
import org.vootoo.client.netty.SolrClientHandler;
import org.vootoo.client.netty.protocol.SolrProtocol;

public class SolrClientChannelPoolHandler
implements ChannelPoolHandler {
    private static final Logger logger = LoggerFactory.getLogger(SolrClientChannelPoolHandler.class);
    private static final int MB = 0x100000;
    protected final HandlerConfig handlerConfig;
    protected final SocketAddress socketAddress;

    public SolrClientChannelPoolHandler(HandlerConfig handlerConfig, SocketAddress socketAddress) {
        this.handlerConfig = handlerConfig;
        this.socketAddress = socketAddress;
    }

    public void channelReleased(Channel ch) throws Exception {
        logger.debug("channel={} Released", (Object)ch);
    }

    public void channelAcquired(Channel ch) throws Exception {
        logger.debug("channel={} Acquired", (Object)ch);
    }

    public void channelCreated(Channel ch) throws Exception {
        this.initChannel(ch);
        logger.info("connect [{}] success channel={}", (Object)this.socketAddress, (Object)ch);
    }

    protected void initChannel(Channel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast("frame-decoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(this.handlerConfig.getMaxFrameLengthMB() * 0x100000, 0, 4, 0, 4));
        pipeline.addLast("frame-encoder", (ChannelHandler)new LengthFieldPrepender(4));
        pipeline.addLast("pb-decoder", (ChannelHandler)new ProtobufDecoder((MessageLite)SolrProtocol.SolrResponse.getDefaultInstance()));
        pipeline.addLast("pb-encoder", (ChannelHandler)new ProtobufEncoder());
        pipeline.addLast("vootoo_solr_handler", (ChannelHandler)new SolrClientHandler(this.getResponsePromiseContainer()));
    }

    public ResponsePromiseContainer getResponsePromiseContainer() {
        return this.handlerConfig.getResponsePromiseContainer();
    }
}

