/*
 * Decompiled with CFR 0.152.
 */
package org.vootoo.client.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.BinaryRequestWriter;
import org.apache.solr.client.solrj.impl.BinaryResponseParser;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vootoo.client.PackageInfo;
import org.vootoo.client.netty.HandlerConfig;
import org.vootoo.client.netty.NettyUtil;
import org.vootoo.client.netty.ProtobufRequestSetter;
import org.vootoo.client.netty.ResponsePromise;
import org.vootoo.client.netty.SolrClientHandler;
import org.vootoo.client.netty.connect.ConnectionPool;
import org.vootoo.client.netty.connect.ConnectionPoolContext;
import org.vootoo.client.netty.connect.SimpleConnectionPool;
import org.vootoo.client.netty.protocol.SolrProtocol;
import org.vootoo.client.netty.util.ProtobufUtil;
import org.vootoo.common.VootooException;

public class NettySolrClient
extends SolrClient {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(NettySolrClient.class);
    private static final Logger requestLogger = LoggerFactory.getLogger((String)(PackageInfo.packageName() + ".Request"));
    private static final String DEFAULT_PATH = "/select";
    private int defaultTimeout = 2000;
    private final String serverUrl;
    private ConnectionPool connectionPool;
    protected ModifiableSolrParams invariantParams;
    protected ResponseParser parser = new BinaryResponseParser();
    protected RequestWriter requestWriter = new BinaryRequestWriter();

    public NettySolrClient(String host, int port) {
        this(new SimpleConnectionPool(NettyUtil.DEFAULT_BOOTSTRAP, new InetSocketAddress(host, port)));
    }

    public NettySolrClient(String host, int port, HandlerConfig handlerConfig) {
        this(new SimpleConnectionPool(NettyUtil.DEFAULT_BOOTSTRAP, handlerConfig, new InetSocketAddress(host, port)));
    }

    public NettySolrClient(ConnectionPool connectionPool) {
        this.connectionPool = connectionPool;
        this.serverUrl = "netty://" + connectionPool.channelHost() + ":" + connectionPool.channelPort();
    }

    protected ResponseParser createRequest(SolrRequest request, ProtobufRequestSetter saveRequestSetter) throws SolrServerException, IOException {
        Integer timeout;
        ResponseParser parser;
        SolrParams params = request.getParams();
        Collection streams = this.requestWriter.getContentStreams(request);
        String path = this.requestWriter.getPath(request);
        if (path == null || !path.startsWith("/")) {
            path = DEFAULT_PATH;
        }
        if ((parser = request.getResponseParser()) == null) {
            parser = this.parser;
        }
        ModifiableSolrParams wparams = new ModifiableSolrParams(params);
        if (parser != null) {
            wparams.set("wt", new String[]{parser.getWriterType()});
            wparams.set("version", new String[]{parser.getVersion()});
        }
        if (this.invariantParams != null) {
            wparams.add((SolrParams)this.invariantParams);
        }
        if ((timeout = wparams.getInt("timeAllowed")) == null) {
            timeout = this.defaultTimeout;
            wparams.set("timeAllowed", timeout.intValue());
        }
        saveRequestSetter.setTimeout(timeout);
        saveRequestSetter.setPath(path);
        saveRequestSetter.setSolrParams((SolrParams)wparams);
        if (request.getMethod() != null) {
            saveRequestSetter.setMethod(request.getMethod());
        }
        if (SolrRequest.METHOD.GET == request.getMethod()) {
            if (streams != null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "GET can't send streams!");
            }
            return parser;
        }
        if (SolrRequest.METHOD.POST == request.getMethod() || SolrRequest.METHOD.PUT == request.getMethod()) {
            if (streams != null) {
                saveRequestSetter.setContentStreams(streams);
            }
            return parser;
        }
        throw new SolrServerException("Unsupported method: " + request.getMethod());
    }

    protected VootooException createTimeoutException(long rid, int timeout, SolrParams solrParams) {
        return this.createTimeoutException(rid, timeout, "", solrParams);
    }

    protected VootooException createTimeoutException(long rid, int timeout, String tip, SolrParams solrParams) {
        VootooException vootooException = new VootooException(VootooException.VootooErrorCode.TIMEOUT, "rid=" + rid + ", [" + this.serverUrl() + "] is timeout=" + timeout + ", " + tip + " request=[" + solrParams + "]");
        vootooException.setRemoteServer(this.serverUrl());
        return vootooException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamedList<Object> request(SolrRequest request, String collection) throws SolrServerException, IOException {
        ProtobufRequestSetter protobufRequestSetter = new ProtobufRequestSetter();
        if (collection != null) {
            protobufRequestSetter.setCollection(collection);
        }
        ResponseParser parser = this.createRequest(request, protobufRequestSetter);
        SolrParams solrParams = protobufRequestSetter.getSolrParams();
        int timeout = protobufRequestSetter.getTimeout() + 20;
        ConnectionPoolContext poolContext = this.connectionPool.poolContext();
        ResponsePromise responsePromise = poolContext.createResponsePromise();
        Long rid = responsePromise.getRid();
        SolrClientHandler solrClientHandler = null;
        try {
            SolrProtocol.SolrRequest protocolRequest = protobufRequestSetter.setRid(rid).buildProtocolRequest();
            Channel channel = null;
            ChannelFuture writeFuture = null;
            try {
                channel = this.connectionPool.acquireConnect();
                solrClientHandler = SolrClientHandler.getSolrClientHandler(channel);
                writeFuture = solrClientHandler.writeRequest(channel, protocolRequest, responsePromise);
            }
            finally {
                if (channel != null) {
                    this.connectionPool.releaseConnect(channel);
                }
            }
            boolean writeDone = writeFuture.awaitUninterruptibly((long)timeout);
            if (!writeDone) {
                throw this.createTimeoutException(rid, timeout, "write request timeout", solrParams);
            }
            SolrProtocol.SolrResponse protocolResponse = responsePromise.waitResult(timeout);
            if (protocolResponse == null) {
                throw this.createTimeoutException(rid, timeout, solrParams);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("rid={}, [{}] response size={}", new Object[]{rid, this.serverUrl(), protocolResponse.getSerializedSize()});
            }
            if (protocolResponse.getExceptionBodyCount() > 0) {
                ArrayList<VootooException> solrExcs = new ArrayList<VootooException>(protocolResponse.getExceptionBodyCount());
                VootooException firstE = null;
                int eNum = 0;
                for (SolrProtocol.ExceptionBody e : protocolResponse.getExceptionBodyList()) {
                    VootooException se = ProtobufUtil.toVootooException(e);
                    se.setRemoteServer(this.serverUrl());
                    if (se.code() != SolrException.ErrorCode.UNKNOWN.code && firstE == null) {
                        firstE = se;
                    }
                    solrExcs.add(se);
                    ++eNum;
                    if (logger.isDebugEnabled()) {
                        logger.debug("[WARN] rid={}, [{}] response exception ({}/{}), code={}, msg={}, meta={}, trace={}", new Object[]{rid, se.getRemoteServer(), eNum, protocolResponse.getExceptionBodyCount(), se.code(), se.getMessage(), se.getMetadata(), se.getRemoteTrace()});
                        continue;
                    }
                    if (!logger.isInfoEnabled()) continue;
                    logger.info("[WARN] rid={}, [{}] response exception ({}/{}), code={}, msg={}, meta={}", new Object[]{rid, se.getRemoteServer(), eNum, protocolResponse.getExceptionBodyCount(), se.code(), se.getMessage(), se.getMetadata()});
                }
                if (firstE != null) {
                    logger.warn("rid={}, [{}] response exception, ErrorCode={}, msg={}, meta={}", new Object[]{rid, firstE.getRemoteServer(), firstE.code(), firstE.getMessage(), firstE.getMetadata()});
                    throw firstE;
                }
                throw new SolrServerException("rid=" + rid + ", [" + this.serverUrl() + "] has unknow error", (Throwable)solrExcs.get(0));
            }
            InputStream responseInputStream = ProtobufUtil.getSolrResponseInputStream(protocolResponse);
            if (responseInputStream == null) {
                logger.warn("rid={}, [{}] not response body, params={}", new Object[]{rid, this.serverUrl(), solrParams});
                throw new SolrServerException("rid=" + rid + ", [" + this.serverUrl() + "] not response body, params=" + solrParams);
            }
            String charset = ProtobufUtil.getResponseBodyCharset(protocolResponse);
            NamedList namedList = parser.processResponse(responseInputStream, charset);
            return namedList;
        }
        finally {
            if (solrClientHandler != null) {
                solrClientHandler.removeResponsePromise(rid);
            }
        }
    }

    public String serverUrl() {
        return this.serverUrl;
    }

    public void shutdown() {
        this.connectionPool.close();
    }

    public ModifiableSolrParams getInvariantParams() {
        return this.invariantParams;
    }

    public ResponseParser getParser() {
        return this.parser;
    }

    public void setParser(ResponseParser responseParser) {
        this.parser = responseParser;
    }

    public void setRequestWriter(RequestWriter requestWriter) {
        this.requestWriter = requestWriter;
    }
}

