/*
 * Decompiled with CFR 0.152.
 */
package riotcmd;

import arq.cmdline.ModContext;
import arq.cmdline.ModLangOutput;
import arq.cmdline.ModLangParse;
import arq.cmdline.ModTime;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import jena.cmd.ArgDecl;
import jena.cmd.CmdException;
import jena.cmd.CmdGeneral;
import org.apache.jena.Jena;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.query.ARQ;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFWriterRegistry;
import org.apache.jena.riot.RIOT;
import org.apache.jena.riot.ReaderRIOT;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.SysRIOT;
import org.apache.jena.riot.WriterDatasetRIOTFactory;
import org.apache.jena.riot.WriterGraphRIOTFactory;
import org.apache.jena.riot.lang.StreamRDFCounting;
import org.apache.jena.riot.out.NodeToLabel;
import org.apache.jena.riot.process.inf.InfFactory;
import org.apache.jena.riot.process.inf.InferenceSetupRDFS;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.riot.system.StreamRDFWriter;
import org.apache.jena.riot.system.SyntaxLabels;
import org.apache.jena.riot.tokens.Tokenizer;
import org.apache.jena.riot.tokens.TokenizerFactory;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.system.JenaSystem;

public abstract class CmdLangParse
extends CmdGeneral {
    protected ModTime modTime = new ModTime();
    protected ModLangParse modLangParse = new ModLangParse();
    protected ModLangOutput modLangOutput = new ModLangOutput();
    protected InferenceSetupRDFS setup = null;
    protected ModContext modContext = new ModContext();
    protected ArgDecl strictDecl = new ArgDecl(false, "strict");
    protected boolean cmdStrictMode = false;
    static LangHandler langHandlerQuads;
    static LangHandler langHandlerTriples;
    static LangHandler langHandlerAny;
    protected LangHandler langHandlerOverall = null;
    protected long totalMillis = 0L;
    protected long totalTuples = 0L;
    OutputStream output = System.out;
    StreamRDF outputStream = null;

    protected CmdLangParse(String[] argv) {
        super(argv);
        this.addModule(this.modContext);
        this.addModule(this.modTime);
        this.addModule(this.modLangOutput);
        this.addModule(this.modLangParse);
        this.modVersion.addClass(Jena.class);
        String x1 = ARQ.VERSION;
        String x2 = ARQ.BUILD_DATE;
        this.modVersion.addClass(RIOT.class);
    }

    @Override
    protected String getSummary() {
        return this.getCommandName() + " [--time] [--check|--noCheck] [--sink] [--base=IRI] [--out=FORMAT] [--compress] file ...";
    }

    @Override
    protected void processModulesAndArgs() {
        this.cmdStrictMode = super.contains(this.strictDecl);
    }

    @Override
    protected void exec() {
        boolean oldStrictValue = SysRIOT.isStrictMode();
        if (this.modLangParse.strictMode()) {
            SysRIOT.setStrictMode(true);
        }
        try {
            this.exec$();
        }
        finally {
            SysRIOT.setStrictMode(oldStrictValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exec$() {
        if (this.modLangParse.getRDFSVocab() != null) {
            this.setup = new InferenceSetupRDFS(this.modLangParse.getRDFSVocab());
        }
        if (this.modLangOutput.compressedOutput()) {
            try {
                this.output = new GZIPOutputStream(this.output, true);
            }
            catch (IOException e2) {
                IO.exception(e2);
            }
        }
        this.outputStream = null;
        PostParseHandler postParse = null;
        this.outputStream = this.createStreamSink();
        if (this.outputStream == null) {
            Pair<StreamRDF, PostParseHandler> p = this.createAccumulateSink();
            this.outputStream = p.getLeft();
            postParse = p.getRight();
        }
        try {
            if (super.getPositional().isEmpty()) {
                this.parseFile("-");
            } else {
                boolean b = super.getPositional().size() > 1;
                for (String fn : super.getPositional()) {
                    if (b && !super.isQuiet()) {
                        SysRIOT.getLogger().info("File: " + fn);
                    }
                    this.parseFile(fn);
                }
            }
            if (postParse != null) {
                postParse.postParse();
            }
            if (super.getPositional().size() > 1 && this.modTime.timingEnabled()) {
                this.output("Total", this.totalTuples, this.totalMillis, this.langHandlerOverall);
            }
        }
        finally {
            if (this.output != System.out) {
                IO.close(this.output);
            } else {
                IO.flush(this.output);
            }
            System.err.flush();
        }
    }

    public void parseFile(String filename) {
        TypedInputStream in = null;
        if (filename.equals("-")) {
            in = new TypedInputStream(System.in);
            this.parseFile("http://base/", "stdin", in);
        } else {
            try {
                in = RDFDataMgr.open(filename);
            }
            catch (Exception ex) {
                System.err.println("Can't open '" + filename + "' " + ex.getMessage());
                return;
            }
            this.parseFile(null, filename, in);
            IO.close(in);
        }
    }

    public void parseFile(String defaultBaseURI, String filename, TypedInputStream in) {
        String baseURI = this.modLangParse.getBaseIRI();
        if (baseURI == null) {
            baseURI = defaultBaseURI;
        }
        this.parseRIOT(baseURI, filename, in);
    }

    protected abstract Lang selectLang(String var1, ContentType var2, Lang var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseRIOT(String baseURI, String filename, TypedInputStream in) {
        ContentType ct = in.getMediaType();
        baseURI = SysRIOT.chooseBaseIRI(baseURI, filename);
        boolean checking = true;
        if (this.modLangParse.explicitChecking()) {
            checking = true;
        }
        if (this.modLangParse.explicitNoChecking()) {
            checking = false;
        }
        ErrorHandler errHandler = ErrorHandlerFactory.errorHandlerWarn;
        if (checking) {
            errHandler = this.modLangParse.stopOnBadTerm() ? ErrorHandlerFactory.errorHandlerStd : ErrorHandlerFactory.errorHandlerWarn;
        }
        if (this.modLangParse.skipOnBadTerm()) {
            // empty if block
        }
        Lang lang = this.selectLang(filename, ct, RDFLanguages.NQUADS);
        LangHandler handler = null;
        if (RDFLanguages.isQuads(lang)) {
            handler = langHandlerQuads;
        } else if (RDFLanguages.isTriples(lang)) {
            handler = langHandlerTriples;
        } else {
            throw new CmdException("Undefined language: " + lang);
        }
        if (this.langHandlerOverall == null) {
            this.langHandlerOverall = handler;
        } else if (this.langHandlerOverall != langHandlerAny && this.langHandlerOverall != handler) {
            this.langHandlerOverall = langHandlerAny;
        }
        boolean labelsAsGiven = false;
        NodeToLabel labels = SyntaxLabels.createNodeToLabel();
        StreamRDF s = this.outputStream;
        if (this.setup != null) {
            s = InfFactory.inf(s, this.setup);
        }
        StreamRDFCounting sink = StreamRDFLib.count(s);
        s = null;
        ReaderRIOT reader = RDFDataMgr.createReader(lang);
        try {
            if (checking) {
                if (lang == RDFLanguages.NTRIPLES || lang == RDFLanguages.NQUADS) {
                    reader.setParserProfile(RiotLib.profile(baseURI, false, true, errHandler));
                } else {
                    reader.setParserProfile(RiotLib.profile(baseURI, true, true, errHandler));
                }
            } else {
                reader.setParserProfile(RiotLib.profile(baseURI, false, false, errHandler));
            }
            this.modTime.startTimer();
            sink.start();
            reader.read(in, baseURI, ct, (StreamRDF)sink, null);
            sink.finish();
        }
        catch (RiotException ex) {
            if (this.modLangParse.stopOnBadTerm()) {
                return;
            }
        }
        finally {
            IO.close(in);
        }
        long x = this.modTime.endTimer();
        long n = sink.countTriples() + sink.countQuads();
        if (this.modTime.timingEnabled()) {
            this.output(filename, n, x, handler);
        }
        this.totalMillis += x;
        this.totalTuples += n;
    }

    protected StreamRDF createStreamSink() {
        if (this.modLangParse.toBitBucket()) {
            return StreamRDFLib.sinkNull();
        }
        RDFFormat fmt = this.modLangOutput.getOutputStreamFormat();
        if (fmt == null) {
            return null;
        }
        return StreamRDFWriter.getWriterStream(this.output, fmt);
    }

    protected Pair<StreamRDF, PostParseHandler> createAccumulateSink() {
        final DatasetGraph dsg = DatasetGraphFactory.create();
        StreamRDF sink = StreamRDFLib.dataset(dsg);
        final RDFFormat fmt = this.modLangOutput.getOutputFormatted();
        PostParseHandler handler = new PostParseHandler(){

            @Override
            public void postParse() {
                WriterDatasetRIOTFactory w = RDFWriterRegistry.getWriterDatasetFactory(fmt);
                if (w != null) {
                    RDFDataMgr.write(CmdLangParse.this.output, dsg, fmt);
                    return;
                }
                WriterGraphRIOTFactory wg = RDFWriterRegistry.getWriterGraphFactory(fmt);
                if (wg != null) {
                    RDFDataMgr.write((OutputStream)System.out, dsg.getDefaultGraph(), fmt);
                    return;
                }
                throw new InternalErrorException("failed to find the writer: " + fmt);
            }
        };
        return Pair.create(sink, handler);
    }

    protected Tokenizer makeTokenizer(InputStream in) {
        Tokenizer tokenizer = TokenizerFactory.makeTokenizerUTF8(in);
        return tokenizer;
    }

    protected void output(String label, long numberTriples, long timeMillis, LangHandler handler) {
        double timeSec = (double)timeMillis / 1000.0;
        System.out.flush();
        System.err.printf("%s : %,5.2f sec  %,d %s  %,.2f %s\n", label, (double)timeMillis / 1000.0, numberTriples, handler.getItemsName(), timeSec == 0.0 ? 0.0 : (double)numberTriples / timeSec, handler.getRateName());
    }

    protected void output(String label) {
        System.err.printf("%s : \n", label);
    }

    static {
        JenaSystem.init();
        langHandlerQuads = new LangHandler(){

            @Override
            public String getItemsName() {
                return "quads";
            }

            @Override
            public String getRateName() {
                return "QPS";
            }
        };
        langHandlerTriples = new LangHandler(){

            @Override
            public String getItemsName() {
                return "triples";
            }

            @Override
            public String getRateName() {
                return "TPS";
            }
        };
        langHandlerAny = new LangHandler(){

            @Override
            public String getItemsName() {
                return "tuples";
            }

            @Override
            public String getRateName() {
                return "TPS";
            }
        };
    }

    protected static interface PostParseHandler {
        public void postParse();
    }

    static interface LangHandler {
        public String getItemsName();

        public String getRateName();
    }
}

