/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.main;

import org.apache.jena.query.ARQ;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.optimize.TransformScopeRename;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.Plan;
import org.apache.jena.sparql.engine.QueryEngineBase;
import org.apache.jena.sparql.engine.QueryEngineFactory;
import org.apache.jena.sparql.engine.QueryEngineRegistry;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIterRoot;
import org.apache.jena.sparql.engine.iterator.QueryIteratorCheck;
import org.apache.jena.sparql.engine.iterator.QueryIteratorTiming;
import org.apache.jena.sparql.engine.main.QC;
import org.apache.jena.sparql.util.Context;

public class QueryEngineMain
extends QueryEngineBase {
    private static QueryEngineFactory factory = new QueryEngineMainFactory();

    public static QueryEngineFactory getFactory() {
        return factory;
    }

    public static void register() {
        QueryEngineRegistry.addFactory(factory);
    }

    public static void unregister() {
        QueryEngineRegistry.removeFactory(factory);
    }

    public QueryEngineMain(Op op, DatasetGraph dataset, Binding input, Context context) {
        super(op, dataset, input, context);
    }

    public QueryEngineMain(Query query2, DatasetGraph dataset, Binding input, Context context) {
        super(query2, dataset, input, context);
    }

    @Override
    public QueryIterator eval(Op op, DatasetGraph dsg, Binding input, Context context) {
        ExecutionContext execCxt = new ExecutionContext(context, dsg.getDefaultGraph(), dsg, QC.getFactory(context));
        QueryIterRoot qIter1 = QueryIterRoot.create(input, execCxt);
        QueryIterator qIter = QC.execute(op, qIter1, execCxt);
        qIter = QueryIteratorCheck.check(qIter, execCxt);
        if (context.isTrue(ARQ.enableExecutionTimeLogging)) {
            qIter = QueryIteratorTiming.time(qIter);
        }
        return qIter;
    }

    @Override
    protected Op modifyOp(Op op) {
        if (this.context.isFalse(ARQ.optimization)) {
            return this.minimalModifyOp(op);
        }
        return Algebra.optimize(op, this.context);
    }

    protected Op minimalModifyOp(Op op) {
        return TransformScopeRename.transform(op);
    }

    protected static class QueryEngineMainFactory
    implements QueryEngineFactory {
        protected QueryEngineMainFactory() {
        }

        @Override
        public boolean accept(Query query2, DatasetGraph dataset, Context context) {
            return true;
        }

        @Override
        public Plan create(Query query2, DatasetGraph dataset, Binding input, Context context) {
            QueryEngineMain engine = new QueryEngineMain(query2, dataset, input, context);
            return engine.getPlan();
        }

        @Override
        public boolean accept(Op op, DatasetGraph dataset, Context context) {
            return true;
        }

        @Override
        public Plan create(Op op, DatasetGraph dataset, Binding binding, Context context) {
            QueryEngineMain engine = new QueryEngineMain(op, dataset, binding, context);
            return engine.getPlan();
        }
    }
}

