/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.store;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.jena.sdb.SDB;
import org.apache.jena.sdb.compiler.SqlBuilder;
import org.apache.jena.sdb.core.Annotation1;
import org.apache.jena.sdb.core.SDBRequest;
import org.apache.jena.sdb.core.sqlexpr.SqlColumn;
import org.apache.jena.sdb.core.sqlnode.ColAlias;
import org.apache.jena.sdb.core.sqlnode.SqlNode;
import org.apache.jena.sdb.shared.SDBInternalError;
import org.apache.jena.sdb.sql.RS;
import org.apache.jena.sdb.sql.ResultSetJDBC;
import org.apache.jena.sdb.sql.SDBExceptionSQL;
import org.apache.jena.sdb.store.SQLBridge;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIter;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;

public abstract class SQLBridgeBase
implements SQLBridge {
    private Map<Var, String> varLabels = new HashMap<Var, String>();
    private Annotation1 annotation = new Annotation1();
    private Collection<Var> projectVars = null;
    private SqlNode sqlNodeOriginal = null;
    private SqlNode sqlNode = null;
    protected final SDBRequest request;

    protected SQLBridgeBase(SDBRequest request, SqlNode sqlNode, Collection<Var> projectVars) {
        this.request = request;
        this.sqlNodeOriginal = sqlNode;
        this.projectVars = projectVars;
        this.sqlNode = sqlNode;
    }

    @Override
    public final void build() {
        this.buildValues();
        this.buildProject();
    }

    protected abstract void buildValues();

    protected abstract void buildProject();

    protected abstract Binding assembleBinding(ResultSetJDBC var1, Binding var2);

    @Override
    public final QueryIterator assembleResults(ResultSetJDBC rs, Binding binding, ExecutionContext execCxt) {
        if (execCxt == null || execCxt.getContext().isTrueOrUndef(SDB.jdbcStream)) {
            return new QueryIterSQL(rs, binding, execCxt);
        }
        QueryIterSQL qIter = new QueryIterSQL(rs, binding, execCxt);
        ArrayList<Binding> results = new ArrayList<Binding>();
        while (qIter.hasNext()) {
            results.add(qIter.nextBinding());
        }
        qIter.close();
        return new QueryIterPlainWrapper(results.iterator(), execCxt);
    }

    private void setProjectVars(Collection<Var> projectVars) {
        if (this.projectVars != null) {
            throw new SDBInternalError("SQLBridgeBase: Project vars already set");
        }
        this.projectVars = projectVars;
    }

    protected SqlNode getSqlExprNode() {
        return this.sqlNodeOriginal;
    }

    @Override
    public SqlNode getSqlNode() {
        return this.sqlNode;
    }

    protected void setSqlNode(SqlNode sqlNode2) {
        this.sqlNode = sqlNode2;
    }

    protected Collection<Var> getProject() {
        return this.projectVars;
    }

    protected void addProject(SqlColumn col, String colOutName) {
        this.sqlNode = SqlBuilder.project(this.request, this.sqlNode, new ColAlias(col, new SqlColumn(null, colOutName)));
    }

    protected void addAnnotation(String string) {
        this.annotation.addAnnotation(string);
    }

    protected void setAnnotation() {
        this.annotation.setAnnotation(this.sqlNode);
    }

    protected String allocSqlName(Var v) {
        String sqlVarName = this.varLabels.get(v);
        if (sqlVarName == null) {
            sqlVarName = this.request.genId("V");
            this.varLabels.put(v, sqlVarName);
        }
        return sqlVarName;
    }

    protected String getSqlName(Var v) {
        return this.varLabels.get(v);
    }

    private class QueryIterSQL
    extends QueryIter {
        boolean ready;
        boolean hasNext;
        private ResultSetJDBC jdbcResultSet;
        private Binding parent;

        QueryIterSQL(ResultSetJDBC rs, Binding binding, ExecutionContext execCxt) {
            super(execCxt);
            this.ready = false;
            this.hasNext = false;
            this.jdbcResultSet = rs;
            this.parent = binding;
        }

        @Override
        protected void closeIterator() {
            RS.close(this.jdbcResultSet);
            this.jdbcResultSet = null;
        }

        @Override
        protected boolean hasNextBinding() {
            if (!this.ready) {
                try {
                    this.hasNext = this.jdbcResultSet.get().next();
                }
                catch (SQLException ex) {
                    this.closeIterator();
                    throw new SDBExceptionSQL(ex);
                }
                this.ready = true;
            }
            return this.hasNext;
        }

        @Override
        protected Binding moveToNextBinding() {
            this.ready = false;
            return SQLBridgeBase.this.assembleBinding(this.jdbcResultSet, this.parent);
        }

        @Override
        protected void requestCancel() {
        }
    }
}

