/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.layout2;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import org.apache.jena.graph.Node;
import org.apache.jena.sdb.SDBException;
import org.apache.jena.sdb.layout2.NodeLayout2;
import org.apache.jena.sdb.layout2.TupleLoaderBasics;
import org.apache.jena.sdb.sql.SDBConnection;
import org.apache.jena.sdb.sql.TableUtils;
import org.apache.jena.sdb.store.TableDesc;
import org.apache.jena.sparql.util.NodeUtils;

public abstract class TupleLoaderBase
extends org.apache.jena.sdb.store.TupleLoaderBase
implements TupleLoaderBasics {
    PreparedStatement insertTupleLoader;
    PreparedStatement insertNodeLoader;
    String insertNodes;
    String insertTuples;
    PreparedStatement deleteTuples;
    PreparedStatement deleteAllTuples;
    PreparedStatement clearTupleLoader;
    PreparedStatement clearNodeLoader;
    int chunkSize;
    boolean amLoading;
    int tupleNum;
    Set<Long> seenNodes;

    public TupleLoaderBase(SDBConnection connection, TableDesc tableDesc, int chunkSize) {
        super(connection, tableDesc);
        this.chunkSize = chunkSize;
        this.amLoading = true;
        this.tupleNum = 0;
        this.seenNodes = new HashSet<Long>();
        try {
            this.init();
        }
        catch (SQLException e2) {
            throw new SDBException("Problem initialising loader for [" + tableDesc + "]", e2);
        }
    }

    protected void init() throws SQLException {
        this.ensureTempTables();
        this.insertNodeLoader = this.connection().prepareStatement(this.getInsertTempNodes());
        this.insertTupleLoader = this.connection().prepareStatement(this.getInsertTempTuples());
        this.insertNodes = this.getLoadNodes();
        this.insertTuples = this.getLoadTuples();
        this.deleteTuples = this.connection().prepareStatement(this.getDeleteTuples());
        this.deleteAllTuples = this.connection().prepareStatement(this.getDeleteAllTuples());
        this.clearNodeLoader = this.connection().prepareStatement(this.getClearTempNodes());
        this.clearTupleLoader = this.connection().prepareStatement(this.getClearTempTuples());
    }

    public int getArity() {
        return this.getTableWidth();
    }

    @Override
    public void load(Node ... row) {
        if (!this.amLoading) {
            this.flush();
            this.amLoading = true;
        }
        if (row.length != this.getTableWidth()) {
            throw new IllegalArgumentException("Tuple size mismatch");
        }
        try {
            for (int i = 0; i < row.length; ++i) {
                PreparedNode pNode = new PreparedNode(row[i]);
                if (this.seenNodes.add(pNode.hash)) {
                    pNode.addToStatement(this.insertNodeLoader);
                }
                this.insertTupleLoader.setLong(i + 1, pNode.hash);
            }
            this.insertTupleLoader.addBatch();
        }
        catch (SQLException e2) {
            throw new SDBException("Problem adding to prepared loader statements", e2);
        }
        ++this.tupleNum;
        if (this.tupleNum >= this.chunkSize) {
            this.flush();
        }
    }

    @Override
    public void unload(Node ... row) {
        if (this.amLoading) {
            this.flush();
            this.amLoading = false;
        }
        if (row.length != this.getTableWidth()) {
            if (row.length == 0 && this.getTableWidth() == 3 || row.length == 1) {
                this.massDelete(row);
                return;
            }
            throw new IllegalArgumentException("Tuple size mismatch");
        }
        try {
            for (int i = 0; i < row.length; ++i) {
                PreparedNode pNode = new PreparedNode(row[i]);
                this.deleteTuples.setLong(i + 1, pNode.hash);
            }
            this.deleteTuples.addBatch();
        }
        catch (SQLException e2) {
            throw new SDBException("Problem adding to prepared delete statements", e2);
        }
        ++this.tupleNum;
        if (this.tupleNum >= this.chunkSize) {
            this.flush();
        }
    }

    private void massDelete(Node ... row) {
        this.flush();
        boolean handleT = TupleLoaderBase.startTransaction(this.connection());
        try {
            if (row.length == 0) {
                this.deleteAllTuples.execute();
            } else {
                PreparedNode pNode = new PreparedNode(row[0]);
                this.deleteAllTuples.setLong(1, pNode.hash);
                this.deleteAllTuples.addBatch();
                this.deleteAllTuples.executeBatch();
                this.deleteAllTuples.clearBatch();
            }
            TupleLoaderBase.endTransaction(this.connection(), handleT);
        }
        catch (SQLException e2) {
            if (handleT) {
                try {
                    this.connection().getSqlConnection().rollback();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
            }
            throw new SDBException("Exception mass deleting", e2);
        }
    }

    @Override
    public void finish() {
        super.finish();
        this.flush();
    }

    @Override
    public void close() {
        super.close();
        try {
            this.connection().closePreparedStatement(this.insertTupleLoader);
            this.connection().closePreparedStatement(this.insertNodeLoader);
            this.connection().closePreparedStatement(this.deleteTuples);
            this.connection().closePreparedStatement(this.deleteAllTuples);
            this.connection().closePreparedStatement(this.clearTupleLoader);
            this.connection().closePreparedStatement(this.clearNodeLoader);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private static boolean startTransaction(SDBConnection connection) {
        boolean handleTransaction = false;
        try {
            handleTransaction = connection.getSqlConnection().getAutoCommit();
            if (handleTransaction) {
                connection.getSqlConnection().setAutoCommit(false);
            }
        }
        catch (SQLException e2) {
            throw new SDBException("Failed to get autocommit status", e2);
        }
        return handleTransaction;
    }

    private static void endTransaction(SDBConnection connection, boolean handle) throws SQLException {
        if (!handle) {
            return;
        }
        connection.getSqlConnection().commit();
        connection.getSqlConnection().setAutoCommit(true);
    }

    protected void flush() {
        if (this.tupleNum == 0) {
            return;
        }
        boolean handleTransaction = TupleLoaderBase.startTransaction(this.connection());
        try {
            if (this.amLoading) {
                this.insertNodeLoader.executeBatch();
                this.insertTupleLoader.executeBatch();
                this.connection().execUpdate(this.insertNodes);
                this.connection().execUpdate(this.insertTuples);
                if (!handleTransaction || !this.clearsOnCommit()) {
                    this.clearNodeLoader.execute();
                    this.clearTupleLoader.execute();
                }
            } else {
                this.deleteTuples.executeBatch();
            }
            TupleLoaderBase.endTransaction(this.connection(), handleTransaction);
        }
        catch (SQLException e2) {
            if (handleTransaction) {
                try {
                    this.connection().getSqlConnection().rollback();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
            }
            throw new SDBException("Exception flushing", e2);
        }
        finally {
            this.tupleNum = 0;
            this.seenNodes = new HashSet<Long>();
        }
    }

    public String getNodeLoader() {
        return "NNode" + this.getTableName();
    }

    public String getTupleLoader() {
        return "N" + this.getTableName();
    }

    public String getCreateTempNodes() {
        StringBuilder stmt = new StringBuilder();
        String[] tempBookends = this.getCreateTempTable();
        stmt.append(tempBookends[0]).append(" ").append(this.getNodeLoader()).append(" \n(");
        String[] nodeColTypes = this.getNodeColTypes();
        for (int i = 0; i < nodeColTypes.length; ++i) {
            if (i != 0) {
                stmt.append(" , \n");
            }
            stmt.append("n").append(i).append(" ").append(nodeColTypes[i]);
        }
        stmt.append("\n) ").append(tempBookends[1]);
        return stmt.toString();
    }

    public String getCreateTempTuples() {
        StringBuilder stmt = new StringBuilder();
        String[] tempBookends = this.getCreateTempTable();
        stmt.append(tempBookends[0]).append(" ").append(this.getTupleLoader()).append(" \n(");
        int width = this.getTableWidth();
        for (int i = 0; i < width; ++i) {
            if (i != 0) {
                stmt.append(" , \n");
            }
            stmt.append("t").append(i).append(" ").append(this.getTupleColType());
        }
        stmt.append("\n) ").append(tempBookends[1]);
        return stmt.toString();
    }

    public String getInsertTempNodes() {
        StringBuilder stmt = new StringBuilder();
        stmt.append("INSERT INTO ").append(this.getNodeLoader()).append(" VALUES (");
        for (int i = 0; i < this.getNodeColTypes().length; ++i) {
            if (i != 0) {
                stmt.append(" , ");
            }
            stmt.append("?");
        }
        stmt.append(" )");
        return stmt.toString();
    }

    public String getInsertTempTuples() {
        StringBuilder stmt = new StringBuilder();
        stmt.append("INSERT INTO ").append(this.getTupleLoader()).append(" VALUES (");
        for (int i = 0; i < this.getTableWidth(); ++i) {
            if (i != 0) {
                stmt.append(" , ");
            }
            stmt.append("?");
        }
        stmt.append(" )");
        return stmt.toString();
    }

    public String getLoadNodes() {
        StringBuilder stmt = new StringBuilder();
        stmt.append("INSERT INTO Nodes (hash, lex, lang, datatype, type) \nSELECT ");
        for (int i = 0; i < this.getNodeColTypes().length; ++i) {
            if (i != 0) {
                stmt.append(" , ");
            }
            stmt.append(this.getNodeLoader()).append(".").append("n").append(i);
        }
        stmt.append("\nFROM ").append(this.getNodeLoader()).append(" LEFT JOIN Nodes ON (");
        stmt.append(this.getNodeLoader()).append(".n0=Nodes.hash) \nWHERE Nodes.hash IS NULL");
        return stmt.toString();
    }

    @Override
    public String getClearTempNodes() {
        return "DELETE FROM " + this.getNodeLoader();
    }

    @Override
    public String getClearTempTuples() {
        return "DELETE FROM " + this.getTupleLoader();
    }

    @Override
    public boolean clearsOnCommit() {
        return false;
    }

    private void createTempTables() throws SQLException {
        this.connection().exec(this.getCreateTempNodes());
        this.connection().exec(this.getCreateTempTuples());
    }

    private void ensureTempTables() throws SQLException {
        this.ensureTempTables1();
    }

    private void ensureTempTables1() throws SQLException {
        boolean b = this.connection().loggingSQLExceptions();
        try {
            this.connection().setLogSQLExceptions(false);
            this.createTempTables();
        }
        catch (SQLException ex) {
            TableUtils.dropTableSilent(this.connection(), this.getNodeLoader());
            TableUtils.dropTableSilent(this.connection(), this.getTupleLoader());
            this.createTempTables();
        }
        finally {
            this.connection().setLogSQLExceptions(b);
        }
    }

    private void ensureTempTables2() throws SQLException {
        block6: {
            try {
                if (!TableUtils.hasTable(this.connection().getSqlConnection(), this.getNodeLoader(), new String[0])) {
                    this.connection().execSilent(this.getCreateTempNodes());
                }
                if (!TableUtils.hasTable(this.connection().getSqlConnection(), this.getTupleLoader(), new String[0])) {
                    this.connection().execSilent(this.getCreateTempTuples());
                }
            }
            catch (SQLException e2) {
                String msg = e2.getMessage();
                String className = e2.getClass().getName();
                boolean ignore = false;
                if (className.equals("com.microsoft.sqlserver.jdbc.SQLServerException") && msg.matches("There is already an object named '#.*' in the database.")) {
                    ignore = true;
                }
                if (msg.matches("Table.*already exists")) {
                    ignore = true;
                }
                if (ignore) break block6;
                throw e2;
            }
        }
    }

    public static class PreparedNode {
        public long hash;
        public String lex;
        public String lang;
        public String datatype;
        public int typeId;

        PreparedNode(Node node) {
            this.lex = NodeLayout2.nodeToLex(node);
            this.typeId = NodeLayout2.nodeToType(node);
            this.lang = "";
            this.datatype = "";
            if (node.isLiteral()) {
                this.lang = node.getLiteralLanguage();
                this.datatype = node.getLiteralDatatypeURI();
                if (NodeUtils.isSimpleString(node) || NodeUtils.isLangString(node)) {
                    this.datatype = "";
                }
            }
            this.hash = NodeLayout2.hash(this.lex, this.lang, this.datatype, this.typeId);
        }

        public void addToStatement(PreparedStatement s) throws SQLException {
            s.setLong(1, this.hash);
            s.setString(2, this.lex);
            s.setString(3, this.lang);
            s.setString(4, this.datatype);
            s.setInt(5, this.typeId);
            s.addBatch();
        }

        public int hashCode() {
            return (int)(this.hash & 0xFFFFL);
        }

        public boolean equals(Object other) {
            return ((PreparedNode)other).hash == this.hash;
        }
    }
}

