/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.core.sqlnode;

import java.util.Set;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.sdb.core.AnnotationsBase;
import org.apache.jena.sdb.core.sqlexpr.SqlColumn;
import org.apache.jena.sdb.core.sqlnode.SqlCoalesce;
import org.apache.jena.sdb.core.sqlnode.SqlDistinct;
import org.apache.jena.sdb.core.sqlnode.SqlJoin;
import org.apache.jena.sdb.core.sqlnode.SqlJoinInner;
import org.apache.jena.sdb.core.sqlnode.SqlJoinLeftOuter;
import org.apache.jena.sdb.core.sqlnode.SqlNode;
import org.apache.jena.sdb.core.sqlnode.SqlNodeTextVisitor;
import org.apache.jena.sdb.core.sqlnode.SqlNodeWalker;
import org.apache.jena.sdb.core.sqlnode.SqlProject;
import org.apache.jena.sdb.core.sqlnode.SqlRestrict;
import org.apache.jena.sdb.core.sqlnode.SqlSelectBlock;
import org.apache.jena.sdb.core.sqlnode.SqlTable;
import org.apache.jena.sdb.core.sqlnode.TableFinder;

public abstract class SqlNodeBase
extends AnnotationsBase
implements SqlNode {
    protected String aliasName;

    public SqlNodeBase(String aliasName) {
        this.aliasName = aliasName;
    }

    @Override
    public boolean isJoin() {
        return false;
    }

    @Override
    public boolean isInnerJoin() {
        return false;
    }

    @Override
    public boolean isLeftJoin() {
        return false;
    }

    @Override
    public SqlJoin asJoin() {
        this.classError(SqlJoin.class);
        return null;
    }

    @Override
    public SqlJoinLeftOuter asLeftJoin() {
        this.classError(SqlJoinLeftOuter.class);
        return null;
    }

    @Override
    public SqlJoinInner asInnerJoin() {
        this.classError(SqlJoinInner.class);
        return null;
    }

    @Override
    public boolean isRestrict() {
        return false;
    }

    @Override
    public SqlRestrict asRestrict() {
        this.classError(SqlRestrict.class);
        return null;
    }

    @Override
    public boolean isProject() {
        return false;
    }

    @Override
    public SqlProject asProject() {
        this.classError(SqlProject.class);
        return null;
    }

    @Override
    public boolean isDistinct() {
        return false;
    }

    @Override
    public SqlDistinct asDistinct() {
        this.classError(SqlDistinct.class);
        return null;
    }

    @Override
    public boolean isCoalesce() {
        return false;
    }

    @Override
    public SqlCoalesce asCoalesce() {
        this.classError(SqlCoalesce.class);
        return null;
    }

    @Override
    public boolean isTable() {
        return false;
    }

    @Override
    public SqlTable asTable() {
        this.classError(SqlTable.class);
        return null;
    }

    @Override
    public boolean isSelectBlock() {
        return false;
    }

    @Override
    public SqlSelectBlock asSelectBlock() {
        this.classError(SqlSelectBlock.class);
        return null;
    }

    @Override
    public void output(IndentedWriter out) {
        this.output(out, true);
    }

    public void output(IndentedWriter out, boolean withAnnotations) {
        this.visit(new SqlNodeTextVisitor(out, withAnnotations));
    }

    public boolean usesColumn(SqlColumn c) {
        return false;
    }

    @Override
    public final String getAliasName() {
        return this.aliasName;
    }

    private void classError(Class<?> wanted) {
        throw new ClassCastException("Wanted class: " + Lib.className(wanted) + " :: Actual class " + Lib.className(this));
    }

    @Override
    public Set<SqlTable> tablesInvolved() {
        TableFinder t = new TableFinder();
        SqlNodeWalker.walk(this, t);
        return t.acc;
    }

    public String toString() {
        IndentedLineBuffer buff = new IndentedLineBuffer();
        this.output(buff, true);
        return buff.asString();
    }
}

