/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sdb.core;

import java.util.HashMap;
import java.util.Map;
import org.apache.jena.query.Query;
import org.apache.jena.sdb.SDB;
import org.apache.jena.sdb.Store;
import org.apache.jena.sdb.core.Generator;
import org.apache.jena.sdb.core.Gensym;
import org.apache.jena.sdb.store.StoreHolder;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarAlloc;
import org.apache.jena.sparql.util.Context;

public class SDBRequest
extends StoreHolder {
    private PrefixMapping prefixMapping;
    private final Query query;
    private VarAlloc varAlloc = new VarAlloc("V");
    public boolean LeftJoinTranslation = true;
    public boolean LimitOffsetTranslation = false;
    public boolean DistinctTranslation = true;
    private Context context;
    private Map<String, Generator> generators = new HashMap<String, Generator>();

    public SDBRequest(Store store, Query query2, Context context) {
        super(store);
        this.query = query2;
        this.prefixMapping = null;
        if (query2 != null) {
            this.prefixMapping = query2.getPrefixMapping();
        }
        if (context == null) {
            context = SDB.getContext();
        }
        this.context = new Context(context);
    }

    public SDBRequest(Store store, PrefixMapping prefixMapping, Context context) {
        super(store);
        this.query = null;
        this.prefixMapping = prefixMapping;
        if (context == null) {
            context = SDB.getContext();
        }
        this.context = new Context(context);
    }

    public SDBRequest(Store store, Query query2) {
        this(store, query2, null);
    }

    public Context getContext() {
        return this.context;
    }

    public PrefixMapping getPrefixMapping() {
        return this.prefixMapping;
    }

    public Query getQuery() {
        return this.query;
    }

    public Store getStore() {
        return this.store();
    }

    public Generator generator(String base) {
        Generator g = this.generators.get(base);
        if (g == null) {
            g = Gensym.create(base);
            this.generators.put(base, g);
        }
        return g;
    }

    public String genId(String base) {
        Generator gen = this.generator(base);
        return gen.next();
    }

    public Var genVar() {
        return this.varAlloc.allocVar();
    }
}

