/*
 * Decompiled with CFR 0.152.
 */
package tdb;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.tdb.TDB;
import com.hp.hpl.jena.tdb.TDBLoader;
import com.hp.hpl.jena.tdb.store.GraphTDB;
import java.util.List;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import tdb.cmdline.CmdTDB;
import tdb.cmdline.CmdTDBGraph;
import tdb.cmdline.ModModel;

public class tdbloader
extends CmdTDBGraph {
    private static final ModModel modRDFS = new ModModel("rdfs", new String[0]);
    private boolean showProgress = true;
    private boolean doIncremental = false;

    public static void main(String ... argv) {
        CmdTDB.init();
        TDB.setOptimizerWarningFlag(false);
        new tdbloader(argv).mainRun();
    }

    protected tdbloader(String[] argv) {
        super(argv);
    }

    @Override
    protected void processModulesAndArgs() {
        super.processModulesAndArgs();
    }

    @Override
    protected String getSummary() {
        return this.getCommandName() + " [--desc DATASET | -loc DIR] FILE ...";
    }

    @Override
    protected void exec() {
        Lang lang;
        List<String> urls;
        if (this.isVerbose()) {
            System.out.println("Java maximum memory: " + Runtime.getRuntime().maxMemory());
            System.out.println(ARQ.getContext());
        }
        if (this.isVerbose()) {
            this.showProgress = true;
        }
        if (this.isQuiet()) {
            this.showProgress = false;
        }
        if ((urls = this.getPositional()).size() == 0) {
            urls.add("-");
        }
        if (modRDFS.getModel() != null) {
            // empty if block
        }
        boolean allTriples = true;
        for (String url : urls) {
            lang = RDFLanguages.filenameToLang(url, RDFLanguages.NQUADS);
            if (lang == null || !RDFLanguages.isQuads(lang)) continue;
            allTriples = false;
            break;
        }
        if (allTriples && this.graphName == null) {
            this.loadDefaultGraph(urls);
            return;
        }
        if (this.graphName == null) {
            this.loadQuads(urls);
            return;
        }
        if (!allTriples) {
            for (String url : urls) {
                lang = RDFLanguages.filenameToLang(url, RDFLanguages.NQUADS);
                if (lang == null) {
                    this.cmdError("File suffix not recognized: " + url);
                }
                if (lang == null || RDFLanguages.isTriples(lang)) continue;
                this.cmdError("Can only load triples into a named model: " + url);
            }
            this.cmdError("Internal error: deteched quad input but can't find it again");
            return;
        }
        this.loadNamedGraph(urls);
    }

    void loadDefaultGraph(List<String> urls) {
        GraphTDB graph = this.getGraph();
        TDBLoader.load(graph, urls, this.showProgress);
    }

    void loadNamedGraph(List<String> urls) {
        GraphTDB graph = this.getGraph();
        TDBLoader.load(graph, urls, this.showProgress);
    }

    void loadQuads(List<String> urls) {
        TDBLoader.load(this.getDatasetGraphTDB(), urls, this.showProgress);
    }
}

