/*
 * Decompiled with CFR 0.152.
 */
package sdb.cmd;

import arq.cmdline.ArgDecl;
import arq.cmdline.CmdArgModule;
import arq.cmdline.CmdGeneral;
import arq.cmdline.ModBase;
import arq.cmdline.ModTime;
import com.hp.hpl.jena.sdb.Store;

public class ModConfig
extends ModBase {
    protected final ArgDecl argDeclFormat = new ArgDecl(false, "format", new String[0]);
    protected final ArgDecl argDeclCreate = new ArgDecl(false, "create", new String[0]);
    protected final ArgDecl argDeclDropIndexes = new ArgDecl(false, "dropIndexes", "drop");
    protected final ArgDecl argDeclIndexes = new ArgDecl(false, "addIndexes", "indexes", "index");
    private boolean format = false;
    private boolean createStore = false;
    private boolean dropIndexes = false;
    private boolean createIndexes = false;

    @Override
    public void registerWith(CmdGeneral cmdLine) {
        cmdLine.add(this.argDeclCreate, "--create", "Format a database and add indexes");
        cmdLine.add(this.argDeclFormat, "--format", "Format a database (no indexes)");
        cmdLine.add(this.argDeclDropIndexes, "--drop", "Drop indexes");
        cmdLine.add(this.argDeclIndexes, "--indexes", "Add indexes");
    }

    @Override
    public void processArgs(CmdArgModule cmdLine) {
        this.format = cmdLine.contains(this.argDeclFormat);
        this.createStore = cmdLine.contains(this.argDeclCreate);
        this.dropIndexes = cmdLine.contains(this.argDeclDropIndexes);
        this.createIndexes = cmdLine.contains(this.argDeclIndexes);
    }

    public boolean addIndexes() {
        return this.createIndexes;
    }

    public boolean dropIndexes() {
        return this.dropIndexes;
    }

    public boolean format() {
        return this.format;
    }

    public boolean createStore() {
        return this.createStore;
    }

    public void enact(Store store) {
        this.enact(store, null);
    }

    public void enact(Store store, ModTime timer) {
        long time;
        if (this.createStore()) {
            if (timer != null) {
                timer.startTimer();
            }
            store.getTableFormatter().create();
            if (timer != null) {
                time = timer.endTimer();
                this.printTime("create", time);
            }
        }
        if (this.format() && !this.createStore()) {
            if (timer != null) {
                timer.startTimer();
            }
            store.getTableFormatter().format();
            if (timer != null) {
                time = timer.endTimer();
                this.printTime("format", time);
            }
        }
        if (this.dropIndexes()) {
            if (timer != null) {
                timer.startTimer();
            }
            store.getTableFormatter().dropIndexes();
            if (timer != null) {
                time = timer.endTimer();
                this.printTime("drop indexes", time);
            }
        }
        if (this.addIndexes()) {
            if (timer != null) {
                timer.startTimer();
            }
            store.getTableFormatter().addIndexes();
            if (timer != null) {
                time = timer.endTimer();
                this.printTime("add indexes", time);
            }
        }
    }

    private void printTime(String string, long timeMilli) {
        System.out.printf("Operation: %s: Time %.3f seconds\n", string, (double)timeMilli / 1000.0);
    }
}

