/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.sys;

import com.hp.hpl.jena.tdb.TDBException;
import com.hp.hpl.jena.tdb.base.file.FileSet;
import com.hp.hpl.jena.tdb.sys.Names;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.lib.Tuple;
import org.apache.jena.atlas.logging.Log;

public class FileRef {
    private final String filename;
    private final int id;
    static final int idxOffset = 10;
    static final String journalName = "journal";
    static final int journalIdx = 9;
    static Map<String, Integer> name2id = new HashMap<String, Integer>();
    static Map<Integer, FileRef> id2name = new TreeMap<Integer, FileRef>();
    public static final FileRef Journal;

    private static void printTable() {
        for (String name : Names.tripleIndexes) {
            FileRef.bTree(name);
        }
        for (String name : Names.quadIndexes) {
            FileRef.bTree(name);
        }
        FileRef.bTree("prefixes");
        FileRef.bTree("prefix2id");
        FileRef.file("nodes.dat");
        FileRef.bTree("node2id");
        FileRef.bTree("prefixIdx");
        for (Map.Entry<Integer, FileRef> e2 : id2name.entrySet()) {
            System.out.printf("    add(%s+idxOffset , %s) ;\n", e2.getKey() - 10, '\"' + e2.getValue().filename + '\"');
        }
    }

    private static void add(int idx, String fn) {
        name2id.put(fn, idx);
        id2name.put(idx, new FileRef(fn, idx));
    }

    private static void bTree(String name) {
        FileRef.file(name + ".idn");
        FileRef.file(name + ".dat");
    }

    public static void file(String name) {
        int idx = name2id.size() + 10;
        name2id.put(name, idx);
        id2name.put(idx, new FileRef(name, idx));
    }

    public static FileRef create(FileSet fileSet, String ext) {
        return FileRef.create(fileSet.filename(ext));
    }

    public static FileRef create(String filename) {
        Tuple<String> x = FileOps.splitDirFile(filename);
        String key = x.get(1);
        if (!name2id.containsKey(key)) {
            Log.warn(FileRef.class, "File name not registered: " + filename);
            FileRef.file(key);
        }
        return new FileRef(key, name2id.get(key));
    }

    public static FileRef get(int fileId) {
        FileRef f = id2name.get(fileId);
        if (f == null) {
            Log.fatal(FileRef.class, "No FileRef registered for id: " + fileId);
            throw new TDBException("No FileRef registered for id: " + fileId);
        }
        return f;
    }

    private FileRef(String filename, int id) {
        if (filename == null) {
            throw new IllegalArgumentException("Null for a FileRef filename");
        }
        this.filename = filename.intern();
        this.id = id;
    }

    public String getFilename() {
        return this.filename;
    }

    public String toString() {
        return "fileref(" + this.id + "):" + this.filename;
    }

    public int getId() {
        return this.id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.filename == null ? 0 : this.filename.hashCode());
        result = 31 * result + this.id;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileRef other = (FileRef)obj;
        if (this.id != other.id) {
            return false;
        }
        return Lib.equal(this.filename, other.filename);
    }

    static {
        FileRef.add(9, journalName);
        FileRef.add(10, "SPO.idn");
        FileRef.add(11, "SPO.dat");
        FileRef.add(12, "POS.idn");
        FileRef.add(13, "POS.dat");
        FileRef.add(14, "OSP.idn");
        FileRef.add(15, "OSP.dat");
        FileRef.add(16, "GSPO.idn");
        FileRef.add(17, "GSPO.dat");
        FileRef.add(18, "GPOS.idn");
        FileRef.add(19, "GPOS.dat");
        FileRef.add(20, "GOSP.idn");
        FileRef.add(21, "GOSP.dat");
        FileRef.add(22, "POSG.idn");
        FileRef.add(23, "POSG.dat");
        FileRef.add(24, "OSPG.idn");
        FileRef.add(25, "OSPG.dat");
        FileRef.add(26, "SPOG.idn");
        FileRef.add(27, "SPOG.dat");
        FileRef.add(28, "prefixes.idn");
        FileRef.add(29, "prefixes.dat");
        FileRef.add(30, "prefix2id.idn");
        FileRef.add(31, "prefix2id.dat");
        FileRef.add(32, "nodes.dat");
        FileRef.add(33, "node2id.idn");
        FileRef.add(34, "node2id.dat");
        FileRef.add(35, "prefixIdx.idn");
        FileRef.add(36, "prefixIdx.dat");
        FileRef.add(60, "TEST");
        FileRef.add(61, "TEST1");
        FileRef.add(62, "TEST2");
        Journal = FileRef.get(9);
    }
}

