/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.index.bplustree;

import com.hp.hpl.jena.tdb.TDBException;
import com.hp.hpl.jena.tdb.base.block.Block;
import com.hp.hpl.jena.tdb.base.block.BlockConverter;
import com.hp.hpl.jena.tdb.base.block.BlockMgr;
import com.hp.hpl.jena.tdb.base.block.BlockType;
import com.hp.hpl.jena.tdb.base.buffer.PtrBuffer;
import com.hp.hpl.jena.tdb.base.buffer.RecordBuffer;
import com.hp.hpl.jena.tdb.index.bplustree.BPTreeException;
import com.hp.hpl.jena.tdb.index.bplustree.BPTreeNode;
import com.hp.hpl.jena.tdb.index.bplustree.BPTreePage;
import com.hp.hpl.jena.tdb.index.bplustree.BPTreePageMgr;
import com.hp.hpl.jena.tdb.index.bplustree.BPTreeRecords;
import com.hp.hpl.jena.tdb.index.bplustree.BPlusTree;
import com.hp.hpl.jena.tdb.index.bplustree.BPlusTreeParams;
import java.nio.ByteBuffer;

public final class BPTreeNodeMgr
extends BPTreePageMgr<BPTreeNode> {
    public BPTreeNodeMgr(BPlusTree bpTree, BlockMgr blockMgr) {
        super(bpTree, new Block2BPTreeNode(bpTree), blockMgr);
    }

    public int createEmptyBPT() {
        BPTreeRecords recordsPage = this.bpTree.getRecordsMgr().create();
        if (recordsPage.getId() != 0) {
            throw new TDBException("Root blocks must be at position zero");
        }
        ((BPTreePage)recordsPage).write();
        ((BPTreePage)recordsPage).release();
        BPTreeNode n = this.createNode(-2);
        n.ptrs.setSize(0);
        n.ptrs.add(recordsPage.getId());
        n.isLeaf = true;
        n.setCount(0);
        int rootId = n.getId();
        n.write();
        n.release();
        return rootId;
    }

    public BPTreeNode createNode(int parent) {
        BPTreeNode n = (BPTreeNode)this.create(BlockType.BPTREE_BRANCH);
        n.isLeaf = false;
        n.parent = parent;
        return n;
    }

    public BPTreeNode getRoot(int id) {
        return this.getRead(id, -2);
    }

    @Override
    public BPTreeNode getWrite(int id) {
        throw new UnsupportedOperationException("call getWrite(int, int)");
    }

    @Override
    public BPTreeNode getRead(int id) {
        throw new UnsupportedOperationException("call getRead(int, int)");
    }

    public BPTreeNode getRead(int id, int parent) {
        BPTreeNode n = (BPTreeNode)super.getRead(id);
        n.parent = parent;
        return n;
    }

    public BPTreeNode getWrite(int id, int parent) {
        BPTreeNode n = (BPTreeNode)super.getWrite(id);
        n.parent = parent;
        return n;
    }

    private static final BlockType getType(int x) {
        return BlockType.extract(x >>> 24);
    }

    private static final int encodeCount(BlockType type, int i) {
        return type.id() << 24 | i & 0xFFFFFF;
    }

    private static final int decodeCount(int i) {
        return i & 0xFFFFFF;
    }

    private static BPTreeNode overlay(BPlusTree bpTree, Block block, boolean asLeaf, int count) {
        BPTreeNode n = new BPTreeNode(bpTree, block);
        BPTreeNodeMgr.formatBPTreeNode(n, bpTree, block, asLeaf, -2, count);
        return n;
    }

    static void formatBPTreeNode(BPTreeNode n, BPlusTree bpTree, Block block, boolean leaf, int parent, int count) {
        int header;
        BPlusTreeParams params = bpTree.getParams();
        int ptrBuffLen = params.MaxPtr * params.getPtrLength();
        int recBuffLen = params.MaxRec * params.getRecordLength();
        n.parent = parent;
        n.setCount(count);
        n.isLeaf = leaf;
        int rStart = header = BPlusTreeParams.BlockHeaderSize;
        int pStart = header + recBuffLen;
        int numPtrs = -1;
        if (n.getCount() < 0) {
            numPtrs = 0;
            n.setCount(BPTreeNodeMgr.decodeCount(n.getCount()));
        } else {
            numPtrs = n.getCount() + 1;
        }
        ByteBuffer byteBuffer = block.getByteBuffer();
        byteBuffer.position(rStart);
        byteBuffer.limit(rStart + recBuffLen);
        ByteBuffer bbr = byteBuffer.slice();
        n.setRecordBuffer(new RecordBuffer(bbr, n.getParams().keyFactory, n.getCount()));
        byteBuffer.position(pStart);
        byteBuffer.limit(pStart + ptrBuffLen);
        ByteBuffer bbi = byteBuffer.slice();
        n.ptrs = new PtrBuffer(bbi, numPtrs);
        byteBuffer.rewind();
    }

    static final void formatForRoot(BPTreeNode n, boolean asLeaf) {
        BPTreeNodeMgr.formatBPTreeNode(n, n.getBPlusTree(), n.getBackingBlock(), asLeaf, -2, 0);
    }

    private static class Block2BPTreeNode
    implements BlockConverter<BPTreeNode> {
        private final BPlusTree bpTree;

        Block2BPTreeNode(BPlusTree bpTree) {
            this.bpTree = bpTree;
        }

        @Override
        public BPTreeNode createFromBlock(Block block, BlockType bType) {
            return BPTreeNodeMgr.overlay(this.bpTree, block, bType == BlockType.RECORD_BLOCK, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BPTreeNode fromBlock(Block block) {
            Block block2 = block;
            synchronized (block2) {
                int x = block.getByteBuffer().getInt(0);
                BlockType type = BPTreeNodeMgr.getType(x);
                if (type != BlockType.BPTREE_BRANCH && type != BlockType.BPTREE_LEAF) {
                    throw new BPTreeException("Wrong block type: " + type);
                }
                int count = BPTreeNodeMgr.decodeCount(x);
                return BPTreeNodeMgr.overlay(this.bpTree, block, type == BlockType.BPTREE_LEAF, count);
            }
        }

        @Override
        public Block toBlock(BPTreeNode node) {
            Block block = node.getBackingBlock();
            BlockType bType = node.isLeaf ? BlockType.BPTREE_LEAF : BlockType.BPTREE_BRANCH;
            int c = BPTreeNodeMgr.encodeCount(bType, node.getCount());
            block.getByteBuffer().putInt(0, c);
            return block;
        }
    }
}

