/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.file;

import com.hp.hpl.jena.tdb.base.file.Location;
import java.io.File;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.atlas.lib.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSet {
    private static Logger log = LoggerFactory.getLogger(FileSet.class);
    private Location location;
    private String basename;

    public static FileSet mem() {
        FileSet fs = new FileSet(Location.mem(), "mem");
        return fs;
    }

    public FileSet(String directory, String basename) {
        this.initFileSet(new Location(directory), basename);
    }

    public FileSet(String filename) {
        Tuple<String> t = FileOps.splitDirFile(filename);
        String dir = t.get(0);
        String fn = t.get(1);
        if (dir == null) {
            dir = ".";
        }
        this.initFileSet(new Location(dir), fn);
    }

    public FileSet(Location directory, String basename) {
        this.initFileSet(directory, basename);
    }

    private void initFileSet(Location directory, String basename) {
        this.initFileSet(directory, basename, false);
    }

    private void initFileSet(Location directory, String basename, boolean useLocationMetadata) {
        this.location = directory;
        this.basename = basename;
    }

    public Location getLocation() {
        return this.location;
    }

    public String getBasename() {
        return this.basename;
    }

    public boolean isMem() {
        return this.location.isMem();
    }

    public boolean exists(String ext) {
        if (this.location.isMem()) {
            return true;
        }
        String fn = this.filename(ext);
        File f = new File(fn);
        if (f.isDirectory()) {
            log.warn("File clashes with a directory");
        }
        return f.exists() && f.isFile();
    }

    public String toString() {
        return "FileSet:" + this.filename(null);
    }

    public String filename(String ext) {
        return this.location.getPath(this.basename, ext);
    }
}

