/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.assembler;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.assembler.exceptions.AssemblerException;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.assembler.DatasetAssembler;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.util.graph.GraphUtils;
import com.hp.hpl.jena.tdb.TDB;
import com.hp.hpl.jena.tdb.TDBFactory;
import com.hp.hpl.jena.tdb.assembler.VocabTDB;
import com.hp.hpl.jena.tdb.base.file.Location;
import org.apache.jena.atlas.logging.Log;

public class DatasetAssemblerTDB
extends DatasetAssembler {
    @Override
    public Dataset createDataset(Assembler a, Resource root, Mode mode) {
        TDB.init();
        return DatasetAssemblerTDB.make(root);
    }

    static Dataset make(Resource root) {
        if (!GraphUtils.exactlyOneProperty(root, VocabTDB.pLocation)) {
            throw new AssemblerException(root, "No location given");
        }
        String dir = GraphUtils.getStringValue(root, VocabTDB.pLocation);
        Location loc = new Location(dir);
        DatasetGraph dsg = TDBFactory.createDatasetGraph(loc);
        if (root.hasProperty(VocabTDB.pUnionDefaultGraph)) {
            Node b = root.getProperty(VocabTDB.pUnionDefaultGraph).getObject().asNode();
            NodeValue nv = NodeValue.makeNode(b);
            if (nv.isBoolean()) {
                dsg.getContext().set(TDB.symUnionDefaultGraph, nv.getBoolean());
            } else {
                Log.warn(DatasetAssemblerTDB.class, "Failed to recognize value for union graph setting (ignored): " + b);
            }
        }
        return DatasetFactory.create(dsg);
    }

    static {
        TDB.init();
    }
}

