/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.SortCondition;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.ARQNotImplemented;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVisitor;
import com.hp.hpl.jena.sparql.algebra.op.OpAssign;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpConditional;
import com.hp.hpl.jena.sparql.algebra.op.OpDatasetNames;
import com.hp.hpl.jena.sparql.algebra.op.OpDiff;
import com.hp.hpl.jena.sparql.algebra.op.OpDisjunction;
import com.hp.hpl.jena.sparql.algebra.op.OpDistinct;
import com.hp.hpl.jena.sparql.algebra.op.OpExt;
import com.hp.hpl.jena.sparql.algebra.op.OpExtend;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpGraph;
import com.hp.hpl.jena.sparql.algebra.op.OpGroup;
import com.hp.hpl.jena.sparql.algebra.op.OpJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpLabel;
import com.hp.hpl.jena.sparql.algebra.op.OpLeftJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpList;
import com.hp.hpl.jena.sparql.algebra.op.OpMinus;
import com.hp.hpl.jena.sparql.algebra.op.OpNull;
import com.hp.hpl.jena.sparql.algebra.op.OpOrder;
import com.hp.hpl.jena.sparql.algebra.op.OpPath;
import com.hp.hpl.jena.sparql.algebra.op.OpProcedure;
import com.hp.hpl.jena.sparql.algebra.op.OpProject;
import com.hp.hpl.jena.sparql.algebra.op.OpPropFunc;
import com.hp.hpl.jena.sparql.algebra.op.OpQuad;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.algebra.op.OpReduced;
import com.hp.hpl.jena.sparql.algebra.op.OpSequence;
import com.hp.hpl.jena.sparql.algebra.op.OpService;
import com.hp.hpl.jena.sparql.algebra.op.OpSlice;
import com.hp.hpl.jena.sparql.algebra.op.OpTable;
import com.hp.hpl.jena.sparql.algebra.op.OpTopN;
import com.hp.hpl.jena.sparql.algebra.op.OpTriple;
import com.hp.hpl.jena.sparql.algebra.op.OpUnion;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.core.VarExprList;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprAggregator;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.ExprTransform;
import com.hp.hpl.jena.sparql.expr.ExprTransformCopy;
import com.hp.hpl.jena.sparql.expr.ExprTransformer;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.pfunction.PropFuncArg;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.ElementAssign;
import com.hp.hpl.jena.sparql.syntax.ElementBind;
import com.hp.hpl.jena.sparql.syntax.ElementData;
import com.hp.hpl.jena.sparql.syntax.ElementFilter;
import com.hp.hpl.jena.sparql.syntax.ElementGroup;
import com.hp.hpl.jena.sparql.syntax.ElementNamedGraph;
import com.hp.hpl.jena.sparql.syntax.ElementOptional;
import com.hp.hpl.jena.sparql.syntax.ElementPathBlock;
import com.hp.hpl.jena.sparql.syntax.ElementService;
import com.hp.hpl.jena.sparql.syntax.ElementSubQuery;
import com.hp.hpl.jena.sparql.syntax.ElementTriplesBlock;
import com.hp.hpl.jena.sparql.syntax.ElementUnion;
import com.hp.hpl.jena.sparql.util.graph.GraphList;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OpAsQuery {
    public static Query asQuery(Op op) {
        Converter converter = new Converter(op);
        return converter.convert();
    }

    private static Set<Var> allocProjectVars() {
        return new LinkedHashSet<Var>();
    }

    private static void addProjectVar(Collection<Var> vars, Var var) {
        vars.add(var);
    }

    public static class SubExprForVar
    extends ExprTransformCopy {
        private final Map<Var, Expr> varExpr;
        private boolean subOccurred = false;

        public SubExprForVar(Map<Var, Expr> varExpr) {
            this.varExpr = varExpr;
        }

        public boolean didChange() {
            return this.subOccurred;
        }

        @Override
        public Expr transform(ExprVar var) {
            if (this.varExpr.containsKey(var.asVar())) {
                this.subOccurred = true;
                return this.varExpr.get(var.asVar()).deepCopy();
            }
            return var.deepCopy();
        }
    }

    public static class Converter
    implements OpVisitor {
        private Query query;
        private Op op;
        private Element element = null;
        private ElementGroup currentGroup = null;
        private Deque<ElementGroup> stack = new ArrayDeque<ElementGroup>();
        private Collection<Var> projectVars = OpAsQuery.access$000();
        private Map<Var, Expr> varExpression = new HashMap<Var, Expr>();
        private int groupDepth = 0;
        private boolean inProject = false;
        private boolean hasRun = false;

        public Converter(Op op) {
            this.query = QueryFactory.create();
            this.op = op;
            this.currentGroup = new ElementGroup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Query convert() {
            if (this.hasRun) {
                return this.query;
            }
            try {
                this.op.visit(this);
                Collection<Var> vars = this.projectVars;
                this.query.setQueryResultStar(vars.isEmpty());
                for (Var var : vars) {
                    if (this.varExpression.containsKey(var)) {
                        this.query.addResultVar(var, this.varExpression.get(var));
                        continue;
                    }
                    this.query.addResultVar(var);
                }
                ElementGroup eg = this.currentGroup;
                this.query.setQueryPattern(eg);
                this.query.setQuerySelectType();
                this.query.setResultVars();
                Query query2 = this.query;
                return query2;
            }
            finally {
                this.hasRun = true;
            }
        }

        Element asElement(Op op) {
            ElementGroup g = this.asElementGroup(op);
            if (g.getElements().size() == 1) {
                return g.getElements().get(0);
            }
            return g;
        }

        ElementGroup asElementGroup(Op op) {
            this.startSubGroup();
            op.visit(this);
            return this.endSubGroup();
        }

        @Override
        public void visit(OpBGP opBGP) {
            this.currentGroup().addElement(this.process(opBGP.getPattern()));
        }

        @Override
        public void visit(OpTriple opTriple) {
            this.currentGroup().addElement(this.process(opTriple.getTriple()));
        }

        @Override
        public void visit(OpQuad opQuad) {
            throw new ARQNotImplemented("OpQuad");
        }

        @Override
        public void visit(OpProcedure opProcedure) {
            throw new ARQNotImplemented("OpProcedure");
        }

        @Override
        public void visit(OpPropFunc opPropFunc) {
            Node s = this.processPropFuncArg(opPropFunc.getSubjectArgs());
            Node o = this.processPropFuncArg(opPropFunc.getObjectArgs());
            Triple t = new Triple(s, opPropFunc.getProperty(), o);
            this.currentGroup().addElement(this.process(t));
        }

        private Node processPropFuncArg(PropFuncArg args) {
            if (args.isNode()) {
                return args.getArg();
            }
            List<Node> list = args.getArgList();
            if (list.size() == 0) {
                return RDF.Nodes.nil;
            }
            BasicPattern bgp = new BasicPattern();
            Node head = GraphList.listToTriples(list, bgp);
            this.currentGroup().addElement(this.process(bgp));
            return head;
        }

        @Override
        public void visit(OpSequence opSequence) {
            boolean nestGroup;
            ElementGroup g = this.currentGroup();
            boolean bl = nestGroup = !g.isEmpty();
            if (nestGroup) {
                this.startSubGroup();
                g = this.currentGroup();
            }
            for (Op op : opSequence.getElements()) {
                Element e2 = this.asElement(op);
                g.addElement(e2);
            }
            if (nestGroup) {
                this.endSubGroup();
            }
        }

        @Override
        public void visit(OpDisjunction opDisjunction) {
            throw new ARQNotImplemented("OpDisjunction");
        }

        private Element process(BasicPattern pattern) {
            if (this.query.getSyntax() == Syntax.syntaxSPARQL_10) {
                ElementTriplesBlock e2 = new ElementTriplesBlock();
                for (Triple t : pattern) {
                    e2.addTriple(t);
                }
                return e2;
            }
            if (this.query.getSyntax() == Syntax.syntaxSPARQL_11 || this.query.getSyntax() == Syntax.syntaxARQ) {
                ElementPathBlock e3 = new ElementPathBlock();
                for (Triple t : pattern) {
                    e3.addTriple(t);
                }
                return e3;
            }
            throw new ARQInternalErrorException("Unrecognized syntax: " + this.query.getSyntax());
        }

        private ElementTriplesBlock process(Triple triple) {
            ElementTriplesBlock e2 = new ElementTriplesBlock();
            e2.addTriple(triple);
            return e2;
        }

        @Override
        public void visit(OpQuadPattern quadPattern) {
            Node graphNode = quadPattern.getGraphNode();
            if (graphNode.equals(Quad.defaultGraphNodeGenerated)) {
                this.currentGroup().addElement(this.process(quadPattern.getBasicPattern()));
            } else {
                this.startSubGroup();
                Element e2 = this.asElement(new OpBGP(quadPattern.getBasicPattern()));
                this.endSubGroup();
                if (!(e2 instanceof ElementGroup)) {
                    ElementGroup g = new ElementGroup();
                    g.addElement(e2);
                    e2 = g;
                }
                ElementNamedGraph graphElt = new ElementNamedGraph(graphNode, e2);
                this.currentGroup().addElement(graphElt);
            }
        }

        @Override
        public void visit(OpPath opPath) {
            ElementPathBlock epb = new ElementPathBlock();
            epb.addTriplePath(opPath.getTriplePath());
            ElementGroup g = this.currentGroup();
            g.addElement(epb);
        }

        @Override
        public void visit(OpJoin opJoin) {
            Element eLeft = this.asElement(opJoin.getLeft());
            ElementGroup eRight = this.asElementGroup(opJoin.getRight());
            ElementGroup g = this.currentGroup();
            g.addElement(eLeft);
            g.addElement(eRight);
        }

        private static boolean emptyGroup(Element element) {
            if (!(element instanceof ElementGroup)) {
                return false;
            }
            ElementGroup eg = (ElementGroup)element;
            return eg.isEmpty();
        }

        @Override
        public void visit(OpLeftJoin opLeftJoin) {
            Element eLeft = this.asElement(opLeftJoin.getLeft());
            ElementGroup eRight = this.asElementGroup(opLeftJoin.getRight());
            if (opLeftJoin.getExprs() != null) {
                for (Expr expr : opLeftJoin.getExprs()) {
                    ElementFilter f = new ElementFilter(expr);
                    eRight.addElement(f);
                }
            }
            ElementGroup g = this.currentGroup();
            if (!Converter.emptyGroup(eLeft)) {
                g.addElement(eLeft);
            }
            ElementOptional opt = new ElementOptional(eRight);
            g.addElement(opt);
        }

        @Override
        public void visit(OpDiff opDiff) {
            throw new ARQNotImplemented("OpDiff");
        }

        @Override
        public void visit(OpMinus opMinus) {
            throw new ARQNotImplemented("OpMinus");
        }

        @Override
        public void visit(OpUnion opUnion) {
            ElementGroup eLeft = this.asElementGroup(opUnion.getLeft());
            ElementGroup eRight = this.asElementGroup(opUnion.getRight());
            if (eLeft instanceof ElementUnion) {
                ElementUnion elUnion = (ElementUnion)((Object)eLeft);
                elUnion.addElement(eRight);
                return;
            }
            ElementUnion elUnion = new ElementUnion();
            elUnion.addElement(eLeft);
            elUnion.addElement(eRight);
            this.currentGroup().addElement(elUnion);
        }

        @Override
        public void visit(OpConditional opCondition) {
            throw new ARQNotImplemented("OpCondition");
        }

        @Override
        public void visit(OpFilter opFilter) {
            Element e2 = this.asElement(opFilter.getSubOp());
            if (this.currentGroup() != e2) {
                this.currentGroup().addElement(e2);
            }
            this.element = this.currentGroup();
            ExprList exprs = opFilter.getExprs();
            for (Expr expr : exprs) {
                ElementFilter f = new ElementFilter(expr);
                this.currentGroup().addElement(f);
            }
        }

        @Override
        public void visit(OpGraph opGraph) {
            this.startSubGroup();
            Element e2 = this.asElement(opGraph.getSubOp());
            this.endSubGroup();
            if (!(e2 instanceof ElementGroup)) {
                ElementGroup g = new ElementGroup();
                g.addElement(e2);
                e2 = g;
            }
            ElementNamedGraph graphElt = new ElementNamedGraph(opGraph.getNode(), e2);
            this.currentGroup().addElement(graphElt);
        }

        @Override
        public void visit(OpService opService) {
            Op op = opService.getSubOp();
            Element x = this.asElement(opService.getSubOp());
            ElementService elt = new ElementService(opService.getService(), x, opService.getSilent());
            this.currentGroup().addElement(elt);
        }

        @Override
        public void visit(OpDatasetNames dsNames) {
            throw new ARQNotImplemented("OpDatasetNames");
        }

        @Override
        public void visit(OpTable opTable) {
            if (opTable.isJoinIdentity()) {
                return;
            }
            ElementData el = new ElementData();
            el.getVars().addAll(opTable.getTable().getVars());
            QueryIterator qIter = opTable.getTable().iterator(null);
            while (qIter.hasNext()) {
                el.getRows().add((Binding)qIter.next());
            }
            qIter.close();
            this.currentGroup().addElement(el);
        }

        @Override
        public void visit(OpExt opExt) {
            throw new ARQNotImplemented("OpExt");
        }

        @Override
        public void visit(OpNull opNull) {
            throw new ARQNotImplemented("OpNull");
        }

        @Override
        public void visit(OpLabel opLabel) {
            if (opLabel.hasSubOp()) {
                opLabel.getSubOp().visit(this);
            }
        }

        @Override
        public void visit(OpAssign opAssign) {
            opAssign.getSubOp().visit(this);
            for (Var v : opAssign.getVarExprList().getVars()) {
                Expr e2 = opAssign.getVarExprList().getExpr(v);
                SubExprForVar sefr = new SubExprForVar(this.varExpression);
                Expr tr = ExprTransformer.transform((ExprTransform)sefr, e2);
                if (this.inTopLevel()) {
                    if (!this.inGroupRecombine(opAssign)) {
                        OpAsQuery.addProjectVar(this.projectVars, v);
                    }
                    this.varExpression.put(v, tr);
                    continue;
                }
                ElementAssign elt = new ElementAssign(v, e2);
                ElementGroup g = this.currentGroup();
                g.addElement(elt);
            }
        }

        @Override
        public void visit(OpExtend opExtend) {
            opExtend.getSubOp().visit(this);
            for (Var v : opExtend.getVarExprList().getVars()) {
                ElementGroup g;
                ElementBind elt;
                Expr e2 = opExtend.getVarExprList().getExpr(v);
                Expr tr = ExprTransformer.transform((ExprTransform)new SubExprForVar(this.varExpression), e2);
                if (this.inTopLevel()) {
                    if (this.groupDepth == 0 || this.inGroupRecombine(opExtend)) {
                        if (!this.inGroupRecombine(opExtend)) {
                            OpAsQuery.addProjectVar(this.projectVars, v);
                        }
                        this.varExpression.put(v, tr);
                        continue;
                    }
                    elt = new ElementBind(v, tr);
                    g = this.currentGroup();
                    g.addElement(elt);
                    continue;
                }
                elt = new ElementBind(v, tr);
                g = this.currentGroup();
                g.addElement(elt);
            }
        }

        @Override
        public void visit(OpList opList) {
        }

        @Override
        public void visit(OpOrder opOrder) {
            List<SortCondition> x = opOrder.getConditions();
            for (SortCondition sc : x) {
                this.query.addOrderBy(sc);
            }
            opOrder.getSubOp().visit(this);
        }

        @Override
        public void visit(OpProject opProject) {
            if (this.inProject) {
                Converter subConverter = new Converter(opProject);
                ElementSubQuery subQuery = new ElementSubQuery(subConverter.convert());
                ElementGroup g = this.currentGroup();
                g.addElement(subQuery);
            } else {
                this.projectVars = OpAsQuery.allocProjectVars();
                this.projectVars.addAll(opProject.getVars());
                this.inProject = true;
                opProject.getSubOp().visit(this);
                this.inProject = false;
            }
        }

        @Override
        public void visit(OpReduced opReduced) {
            this.query.setReduced(true);
            opReduced.getSubOp().visit(this);
        }

        @Override
        public void visit(OpDistinct opDistinct) {
            this.query.setDistinct(true);
            opDistinct.getSubOp().visit(this);
        }

        @Override
        public void visit(OpSlice opSlice) {
            if (opSlice.getStart() != Long.MIN_VALUE) {
                this.query.setOffset(opSlice.getStart());
            }
            if (opSlice.getLength() != Long.MIN_VALUE) {
                this.query.setLimit(opSlice.getLength());
            }
            opSlice.getSubOp().visit(this);
        }

        @Override
        public void visit(OpGroup opGroup) {
            List<ExprAggregator> a = opGroup.getAggregators();
            for (ExprAggregator ea : a) {
                Var givenVar = ea.getAggVar().asVar();
                Expr myAggr = this.query.allocAggregate(ea.getAggregator());
                this.varExpression.put(givenVar, myAggr);
            }
            VarExprList b = opGroup.getGroupVars();
            for (Var v : b.getVars()) {
                Expr e2 = b.getExpr(v);
                if (e2 != null) {
                    this.query.addGroupBy(v, e2);
                    continue;
                }
                this.query.addGroupBy(v);
            }
            ++this.groupDepth;
            opGroup.getSubOp().visit(this);
            --this.groupDepth;
        }

        @Override
        public void visit(OpTopN opTop) {
            throw new ARQNotImplemented("OpTopN");
        }

        private Element lastElement() {
            ElementGroup g = this.currentGroup;
            if (g == null || g.getElements().size() == 0) {
                return null;
            }
            int len = g.getElements().size();
            return g.getElements().get(len - 1);
        }

        private void startSubGroup() {
            ElementGroup g;
            this.push(this.currentGroup);
            this.currentGroup = g = new ElementGroup();
        }

        private ElementGroup endSubGroup() {
            ElementGroup g = this.pop();
            ElementGroup r = this.currentGroup;
            this.currentGroup = g;
            return r;
        }

        private ElementGroup currentGroup() {
            return this.currentGroup;
        }

        private ElementGroup peek() {
            if (this.stack.size() == 0) {
                return null;
            }
            return this.stack.peek();
        }

        private ElementGroup pop() {
            return this.stack.pop();
        }

        private void push(ElementGroup el) {
            this.stack.push(el);
        }

        private boolean inTopLevel() {
            return this.stack.size() == 0;
        }

        private boolean inGroupRecombine(OpExtend op) {
            Op subOp = op.getSubOp();
            if (subOp instanceof OpExtend) {
                return this.inGroupRecombine((OpExtend)subOp);
            }
            if (subOp instanceof OpAssign) {
                return this.inGroupRecombine((OpAssign)subOp);
            }
            return subOp instanceof OpGroup;
        }

        private boolean inGroupRecombine(OpAssign op) {
            Op subOp = op.getSubOp();
            if (subOp instanceof OpExtend) {
                return this.inGroupRecombine((OpExtend)subOp);
            }
            if (subOp instanceof OpAssign) {
                return this.inGroupRecombine((OpAssign)subOp);
            }
            return subOp instanceof OpGroup;
        }
    }
}

