/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.sql;

import com.hp.hpl.jena.sdb.sql.SQLUtils;
import java.sql.Timestamp;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.slf4j.LoggerFactory;

public class FunctionsSQL {
    public static boolean sqlSafeChar(String str2) {
        if (!FunctionsSQL.isLowerCaseSqlChar(str2.charAt(0))) {
            return false;
        }
        for (int i = 0; i < str2.length(); ++i) {
            char ch = str2.charAt(i);
            if (FunctionsSQL.isLowerCaseSqlChar(ch) || FunctionsSQL.isSqlDigit(ch)) continue;
            return false;
        }
        return true;
    }

    public static String replace(String str2, String[] fromArray, String[] toArray) {
        for (int i = 0; i < fromArray.length; ++i) {
            str2 = str2.replace(fromArray[i], toArray[i]);
        }
        return str2;
    }

    public static boolean isLowerCaseSqlChar(char ch) {
        return ch >= 'a' && ch <= 'z';
    }

    public static boolean isSqlDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    public static String toSQLdatetimeString(String lex) {
        try {
            DatatypeFactory f = DatatypeFactory.newInstance();
            XMLGregorianCalendar cal = f.newXMLGregorianCalendar(lex);
            long millis = cal.toGregorianCalendar().getTimeInMillis();
            Timestamp timestamp = new Timestamp(millis);
            return timestamp.toString();
        }
        catch (DatatypeConfigurationException e2) {
            LoggerFactory.getLogger(SQLUtils.class).warn("Failed to convert " + lex, e2);
            return "0000-00-00 00:00:00";
        }
    }
}

