/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.script;

import com.hp.hpl.jena.assembler.assemblers.AssemblerBase;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sdb.SDBException;
import com.hp.hpl.jena.sdb.assembler.AssemblerVocab;
import com.hp.hpl.jena.sdb.script.CmdDesc;
import com.hp.hpl.jena.sdb.script.ScriptVocab;
import com.hp.hpl.jena.sparql.util.graph.GraphUtils;
import com.hp.hpl.jena.util.FileManager;
import java.util.ArrayList;
import java.util.List;

public class ScriptDesc {
    List<CmdDesc> steps = new ArrayList<CmdDesc>();

    public static ScriptDesc read(String filename) {
        AssemblerVocab.init();
        Model m = FileManager.get().loadModel(filename);
        return ScriptDesc.worker(m);
    }

    public static void run(String filename) {
        ScriptDesc desc = ScriptDesc.read(filename);
    }

    public void add(CmdDesc step) {
        this.steps.add(step);
    }

    public List<CmdDesc> getSteps() {
        return this.steps;
    }

    private static ScriptDesc worker(Model m) {
        Resource r = GraphUtils.getResourceByType(m, ScriptVocab.ScriptType);
        if (r == null) {
            throw new SDBException("Can't find command line description");
        }
        return (ScriptDesc)AssemblerBase.general.open(r);
    }
}

