/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.layout2.index;

import com.hp.hpl.jena.sdb.layout2.TupleLoaderBase;
import com.hp.hpl.jena.sdb.sql.SDBConnection;
import com.hp.hpl.jena.sdb.store.TableDesc;

public abstract class TupleLoaderIndexBase
extends TupleLoaderBase {
    public TupleLoaderIndexBase(SDBConnection connection, TableDesc tableDesc, int chunkSize) {
        super(connection, tableDesc, chunkSize);
    }

    @Override
    public String getLoadTuples() {
        int i;
        StringBuilder stmt = new StringBuilder();
        stmt.append("INSERT INTO ").append(this.getTableName()).append(" \nSELECT DISTINCT ");
        for (i = 0; i < this.getTableWidth(); ++i) {
            if (i != 0) {
                stmt.append(" , ");
            }
            stmt.append("NI").append(i).append(".id");
        }
        stmt.append("\nFROM ").append(this.getTupleLoader()).append("\n");
        for (i = 0; i < this.getTableWidth(); ++i) {
            stmt.append("JOIN Nodes AS NI").append(i).append(" ON (");
            stmt.append(this.getTupleLoader()).append(".t").append(i).append("=NI").append(i).append(".hash)\n");
        }
        stmt.append("LEFT JOIN ").append(this.getTableName()).append(" ON (");
        for (i = 0; i < this.getTableWidth(); ++i) {
            if (i != 0) {
                stmt.append(" AND ");
            }
            stmt.append("NI").append(i).append(".id");
            stmt.append("=").append(this.getTableName()).append(".").append(this.getTableDesc().getColNames().get(i));
        }
        stmt.append(")\nWHERE\n");
        for (i = 0; i < this.getTableWidth(); ++i) {
            if (i != 0) {
                stmt.append(" OR\n");
            }
            stmt.append(this.getTableName()).append(".").append(this.getTableDesc().getColNames().get(i)).append(" IS NULL");
        }
        return stmt.toString();
    }

    @Override
    public String getDeleteTuples() {
        StringBuilder stmt = new StringBuilder();
        stmt.append("DELETE FROM ").append(this.getTableName()).append(" \nWHERE\n");
        for (int i = 0; i < this.getTableWidth(); ++i) {
            if (i != 0) {
                stmt.append(" AND\n");
            }
            stmt.append(this.getTableDesc().getColNames().get(i)).append(" IN (SELECT id FROM Nodes WHERE hash = ?) ");
        }
        return stmt.toString();
    }

    @Override
    public String getDeleteAllTuples() {
        StringBuilder stmt = new StringBuilder();
        stmt.append("DELETE FROM ").append(this.getTableName());
        if (this.getTableWidth() != 3) {
            stmt.append(" \nWHERE\n");
            stmt.append(this.getTableDesc().getColNames().get(0));
            stmt.append(" IN (SELECT id FROM Nodes WHERE hash = ?) ");
        }
        return stmt.toString();
    }
}

