/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.layout2;

import com.hp.hpl.jena.sdb.compiler.OpSQL;
import com.hp.hpl.jena.sdb.compiler.QueryCompilerMain;
import com.hp.hpl.jena.sdb.compiler.SDB_QC;
import com.hp.hpl.jena.sdb.core.SDBRequest;
import com.hp.hpl.jena.sdb.core.ScopeEntry;
import com.hp.hpl.jena.sdb.core.sqlexpr.S_Like;
import com.hp.hpl.jena.sdb.core.sqlexpr.SqlColumn;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlNode;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlSelectBlock;
import com.hp.hpl.jena.sdb.util.RegexUtils;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.TransformCopy;
import com.hp.hpl.jena.sparql.algebra.Transformer;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.E_Regex;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprList;

public abstract class QueryCompiler2
extends QueryCompilerMain {
    public QueryCompiler2(SDBRequest request) {
        super(request);
    }

    @Override
    protected Op postProcessSQL(Op op) {
        op = QueryCompiler2.rewriteFilters(op, this.request);
        op = QueryCompiler2.rewriteDistinct(op, this.request);
        op = QueryCompiler2.rewriteLimitOffset(op, this.request);
        return op;
    }

    protected static Op rewriteFilters(Op op, SDBRequest request) {
        FilterOptimizer t = new FilterOptimizer(request);
        return Transformer.transform(t, op);
    }

    private static class FilterOptimizer
    extends TransformCopy {
        private final SDBRequest request;

        public FilterOptimizer(SDBRequest request) {
            this.request = request;
        }

        @Override
        public Op transform(OpFilter opFilter, Op op) {
            if (!SDB_QC.isOpSQL(op)) {
                return super.transform(opFilter, op);
            }
            SqlNode sqlNode = ((OpSQL)op).getSqlNode();
            if (!sqlNode.isSelectBlock()) {
                return super.transform(opFilter, op);
            }
            SqlSelectBlock ssb = sqlNode.asSelectBlock();
            ExprList exprs = opFilter.getExprs();
            ExprList exprs2 = new ExprList();
            for (Expr obj : exprs.getList()) {
                Expr expr = obj;
                Expr expr2 = this.convert(expr, ssb, (OpSQL)op);
                if (expr2 == null) continue;
                exprs2.add(expr2);
            }
            return OpFilter.filter(exprs2, op);
        }

        private Expr convert(Expr expr, SqlSelectBlock ssb, OpSQL opSQL) {
            if (!(expr instanceof E_Regex)) {
                return expr;
            }
            E_Regex regex = (E_Regex)expr;
            Expr exprPattern = regex.getArg(2);
            Expr exprFlags = regex.getArg(3) == null ? null : regex.getArg(3);
            boolean caseInsensitive = false;
            if (exprFlags != null) {
                if (!exprFlags.isConstant()) {
                    return expr;
                }
                String flags = exprFlags.getConstant().asString();
                if (!"i".equals(flags)) {
                    return expr;
                }
                caseInsensitive = true;
            }
            if (!exprPattern.isConstant()) {
                return expr;
            }
            String pattern = exprPattern.getConstant().asString();
            if (pattern == null) {
                return expr;
            }
            String patternLike = RegexUtils.regexToLike(pattern);
            if (patternLike == null) {
                return expr;
            }
            if (!regex.getArg(1).isVariable()) {
                return expr;
            }
            Var v = regex.getArg(1).asVar();
            if (!ssb.getNodeScope().hasColumnForVar(v)) {
                return expr;
            }
            ScopeEntry sc = ssb.getNodeScope().findScopeForVar(v);
            SqlColumn col = new SqlColumn(sc.getColumn().getTable(), "lex");
            S_Like sreg = new S_Like(col, patternLike, caseInsensitive);
            ssb.getConditions().add(sreg);
            return null;
        }
    }
}

