/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.graph;

import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Capabilities;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphEventManager;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.TransactionHandler;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.AllCapabilities;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.sdb.SDB;
import com.hp.hpl.jena.sdb.Store;
import com.hp.hpl.jena.sdb.core.SDBRequest;
import com.hp.hpl.jena.sdb.engine.QueryEngineSDB;
import com.hp.hpl.jena.sdb.graph.EventManagerSDB;
import com.hp.hpl.jena.sdb.graph.PrefixMappingSDB;
import com.hp.hpl.jena.sdb.graph.UpdateHandlerSDB;
import com.hp.hpl.jena.sdb.sql.SDBConnection;
import com.hp.hpl.jena.sdb.store.DatasetStoreGraph;
import com.hp.hpl.jena.sdb.store.StoreLoader;
import com.hp.hpl.jena.sdb.store.StoreLoaderPlus;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.Plan;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingRoot;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NiceIterator;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphSDB
extends GraphBase
implements Graph {
    private static Logger log = LoggerFactory.getLogger(GraphSDB.class);
    protected Store store = null;
    protected int inBulkUpdate = 0;
    protected Node graphNode = Quad.defaultGraphNodeGenerated;
    protected DatasetStoreGraph datasetStore = null;

    public GraphSDB(Store store, String uri) {
        this(store, NodeFactory.createURI(uri));
    }

    public GraphSDB(Store store) {
        this(store, (Node)null);
    }

    public GraphSDB(Store store, Node graphNode) {
        if (graphNode == null) {
            graphNode = Quad.defaultGraphNodeGenerated;
        }
        this.store = store;
        this.graphNode = graphNode;
        this.datasetStore = new DatasetStoreGraph(store, this, SDB.getContext().copy());
    }

    @Override
    public Capabilities getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new AllCapabilities(){

                @Override
                public boolean handlesLiteralTyping() {
                    return false;
                }
            };
        }
        return this.capabilities;
    }

    public Store getStore() {
        return this.store;
    }

    public SDBConnection getConnection() {
        return this.store.getConnection();
    }

    @Override
    public PrefixMapping createPrefixMapping() {
        try {
            String graphURI = null;
            if (Quad.isDefaultGraphGenerated(this.graphNode)) {
                graphURI = "";
            } else if (this.graphNode.isURI()) {
                graphURI = this.graphNode.getURI();
            } else {
                log.warn("Not a URI for graph name");
                graphURI = this.graphNode.toString();
            }
            return new PrefixMappingSDB(graphURI, this.store.getConnection());
        }
        catch (Exception ex) {
            log.warn("Failed to get prefixes: " + ex.getMessage());
            return null;
        }
    }

    private Quad quad(TripleMatch m) {
        Node s = m.getMatchSubject();
        Var sVar = null;
        if (s == null) {
            sVar = Var.alloc("s");
            s = sVar;
        }
        Node p = m.getMatchPredicate();
        Var pVar = null;
        if (p == null) {
            pVar = Var.alloc("p");
            p = pVar;
        }
        Node o = m.getMatchObject();
        Var oVar = null;
        if (o == null) {
            oVar = Var.alloc("o");
            o = oVar;
        }
        return new Quad(this.graphNode, s, p, o);
    }

    @Override
    protected ExtendedIterator<Triple> graphBaseFind(TripleMatch m) {
        SDBRequest cxt = new SDBRequest(this.getStore(), new Query());
        Node s = m.getMatchSubject() == null ? Var.alloc("s") : m.getMatchSubject();
        Node p = m.getMatchPredicate() == null ? Var.alloc("p") : m.getMatchPredicate();
        Node o = m.getMatchObject() == null ? Var.alloc("o") : m.getMatchObject();
        Triple triple = new Triple(s, p, o);
        BasicPattern pattern = new BasicPattern();
        pattern.add(triple);
        OpQuadPattern op = new OpQuadPattern(this.graphNode, pattern);
        Plan plan = QueryEngineSDB.getFactory().create(op, (DatasetGraph)this.datasetStore, BindingRoot.create(), null);
        QueryIterator qIter = plan.iterator();
        if (SDB.getContext().isTrue(SDB.streamGraphAPI)) {
            return new GraphIterator(triple, qIter);
        }
        ArrayList<Binding> bindings2 = new ArrayList<Binding>();
        while (qIter.hasNext()) {
            bindings2.add(qIter.nextBinding());
        }
        qIter.close();
        return new GraphIterator(triple, new QueryIterPlainWrapper(bindings2.iterator()));
    }

    private static Triple bindingToTriple(Triple pattern, Binding binding) {
        Node s = pattern.getSubject();
        Node p = pattern.getPredicate();
        Node o = pattern.getObject();
        Node sResult = s;
        Node pResult = p;
        Node oResult = o;
        if (Var.isVar(s)) {
            sResult = binding.get(Var.alloc(s));
        }
        if (Var.isVar(p)) {
            pResult = binding.get(Var.alloc(p));
        }
        if (Var.isVar(o)) {
            oResult = binding.get(Var.alloc(o));
        }
        Triple resultTriple = new Triple(sResult, pResult, oResult);
        return resultTriple;
    }

    public StoreLoader getBulkLoader() {
        return this.store.getLoader();
    }

    @Override
    @Deprecated
    public BulkUpdateHandler getBulkUpdateHandler() {
        if (this.bulkHandler == null) {
            this.bulkHandler = new UpdateHandlerSDB(this);
        }
        return this.bulkHandler;
    }

    @Override
    public GraphEventManager getEventManager() {
        if (this.gem == null) {
            this.gem = new EventManagerSDB(this);
        }
        return this.gem;
    }

    @Override
    public void performAdd(Triple triple) {
        if (this.inBulkUpdate == 0) {
            this.store.getLoader().startBulkUpdate();
        }
        if (Quad.isDefaultGraphGenerated(this.graphNode)) {
            this.store.getLoader().addTriple(triple);
        } else {
            StoreLoaderPlus x = (StoreLoaderPlus)this.store.getLoader();
            x.addQuad(this.graphNode, triple.getSubject(), triple.getPredicate(), triple.getObject());
        }
        if (this.inBulkUpdate == 0) {
            this.store.getLoader().finishBulkUpdate();
        }
    }

    @Override
    public void performDelete(Triple triple) {
        if (this.inBulkUpdate == 0) {
            this.store.getLoader().startBulkUpdate();
        }
        if (Quad.isDefaultGraphGenerated(this.graphNode)) {
            this.store.getLoader().deleteTriple(triple);
        } else {
            StoreLoaderPlus x = (StoreLoaderPlus)this.store.getLoader();
            x.deleteQuad(this.graphNode, triple.getSubject(), triple.getPredicate(), triple.getObject());
        }
        if (this.inBulkUpdate == 0) {
            this.store.getLoader().finishBulkUpdate();
        }
    }

    public void startBulkUpdate() {
        ++this.inBulkUpdate;
        if (this.inBulkUpdate == 1) {
            this.store.getLoader().startBulkUpdate();
        }
    }

    public void finishBulkUpdate() {
        --this.inBulkUpdate;
        if (this.inBulkUpdate == 0) {
            this.store.getLoader().finishBulkUpdate();
        }
    }

    @Override
    public TransactionHandler getTransactionHandler() {
        return this.store.getConnection().getTransactionHandler();
    }

    @Override
    public int graphBaseSize() {
        return (int)(Quad.isDefaultGraphGenerated(this.graphNode) ? this.store.getSize() : this.store.getSize(this.graphNode));
    }

    public void deleteAll() {
        if (this.inBulkUpdate == 0) {
            this.store.getLoader().startBulkUpdate();
        }
        if (Quad.isDefaultGraphGenerated(this.graphNode)) {
            this.store.getLoader().deleteAll();
        } else {
            ((StoreLoaderPlus)this.store.getLoader()).deleteAll(this.graphNode);
        }
        if (this.inBulkUpdate == 0) {
            this.store.getLoader().finishBulkUpdate();
        }
    }

    class GraphIterator
    extends NiceIterator<Triple> {
        QueryIterator qIter;
        Triple current = null;
        Triple pattern;

        GraphIterator(Triple pattern, QueryIterator qIter) {
            this.qIter = qIter;
            this.pattern = pattern;
        }

        @Override
        public void close() {
            this.qIter.close();
        }

        @Override
        public boolean hasNext() {
            return this.qIter.hasNext();
        }

        @Override
        public Triple next() {
            this.current = GraphSDB.bindingToTriple(this.pattern, this.qIter.nextBinding());
            return this.current;
        }

        @Override
        public void remove() {
            if (this.current != null) {
                GraphSDB.this.delete(this.current);
            }
        }
    }
}

