/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.core.sqlnode;

import com.hp.hpl.jena.sdb.core.Annotations;
import com.hp.hpl.jena.sdb.core.sqlexpr.SqlColumn;
import com.hp.hpl.jena.sdb.core.sqlexpr.SqlExpr;
import com.hp.hpl.jena.sdb.core.sqlexpr.SqlExprList;
import com.hp.hpl.jena.sdb.core.sqlnode.ColAlias;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlCoalesce;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlDistinct;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlJoin;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlJoinInner;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlJoinLeftOuter;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlNode;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlNodeVisitor;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlProject;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlRename;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlRestrict;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlSelectBlock;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlSlice;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlTable;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlUnion;
import com.hp.hpl.jena.sparql.core.Var;
import java.util.Collection;
import java.util.List;
import org.apache.jena.atlas.io.IndentedWriter;

public class SqlNodeTextVisitor
implements SqlNodeVisitor {
    private static final String DelimOpen = "";
    private static final String DelimClose = "";
    static final boolean closeOnSameLine = true;
    private IndentedWriter out;
    private boolean withAnnotations = true;
    private static final int annotationColumn = 40;
    int depth = 0;

    public SqlNodeTextVisitor(IndentedWriter out) {
        this.out = out;
    }

    public SqlNodeTextVisitor(IndentedWriter out, boolean withAnnotations) {
        this.out = out;
        this.withAnnotations = withAnnotations;
    }

    public void visit(SqlProject sqlNode) {
        this.start(sqlNode, "Project", sqlNode.getAliasName());
        if (sqlNode.getCols().size() == 0) {
            this.out.println("<no cols>");
        } else {
            this.print(sqlNode.getCols());
        }
        sqlNode.getSubNode().visit(this);
        this.finish();
    }

    private void print(List<ColAlias> cols) {
        boolean first = true;
        String currentPrefix = null;
        for (ColAlias c : cols) {
            if (!first) {
                this.out.print(" ");
            }
            first = false;
            String cn = c.getColumn().getFullColumnName();
            int j = cn.lastIndexOf(".");
            if (j == -1) {
                currentPrefix = null;
            } else {
                String x = cn.substring(0, j);
                if (currentPrefix != null && !x.equals(currentPrefix)) {
                    this.out.println();
                }
                currentPrefix = x;
            }
            this.out.print(c.getColumn().getFullColumnName());
            if (c.getAlias() == null) continue;
            this.out.print("/");
            this.out.print(c.getAlias().getColumnName());
        }
        this.out.ensureStartOfLine();
    }

    public void visit(SqlDistinct sqlNode) {
        this.start(sqlNode, "Distinct", sqlNode.getAliasName());
        sqlNode.getSubNode().visit(this);
        this.finish();
    }

    public void visit(SqlRestrict sqlNode) {
        this.start(sqlNode, "Restrict", null);
        this.print(sqlNode.getConditions());
        sqlNode.getSubNode().visit(this);
        this.finish();
    }

    private void print(SqlExprList exprs) {
        for (SqlExpr c : exprs) {
            this.out.println(c.toString());
        }
    }

    public void visit(SqlRename sqlRename) {
        this.start(sqlRename, "Rename", sqlRename.getAliasName());
        this.out.incIndent();
        if (!sqlRename.getIdScope().isEmpty()) {
            this.out.println(sqlRename.getIdScope().toString());
        }
        if (!sqlRename.getNodeScope().isEmpty()) {
            this.out.println(sqlRename.getNodeScope().toString());
        }
        this.out.decIndent();
        sqlRename.getSubNode().visit(this);
        this.finish();
    }

    @Override
    public void visit(SqlTable sqlNode) {
        this.out.print("");
        this.out.print("Table ");
        this.out.print(sqlNode.getAliasName());
        this.out.print("");
        this.addAnnotations(sqlNode);
    }

    @Override
    public void visit(SqlJoinInner sqlJoin) {
        this.visitJoin(sqlJoin);
    }

    @Override
    public void visit(SqlJoinLeftOuter sqlJoin) {
        this.visitJoin(sqlJoin);
    }

    @Override
    public void visit(SqlUnion sqlUnion) {
        this.out.ensureStartOfLine();
        this.start(sqlUnion, "Union", sqlUnion.getAliasName());
        if (sqlUnion.getLeft() == null) {
            this.out.println("<null>");
        } else {
            sqlUnion.getLeft().visit(this);
        }
        this.out.println();
        if (sqlUnion.getRight() == null) {
            this.out.println("<null>");
        } else {
            sqlUnion.getRight().visit(this);
        }
        this.finish();
    }

    @Override
    public void visit(SqlCoalesce sqlNode) {
        SqlColumn col;
        this.start(sqlNode, "Coalesce", sqlNode.getAliasName());
        boolean first = true;
        SqlJoin join = sqlNode.getJoinNode();
        for (Var v : sqlNode.getCoalesceVars()) {
            if (!first) {
                this.out.print(" ");
            }
            first = false;
            col = sqlNode.getIdScope().findScopeForVar(v).getColumn();
            this.out.print(v.toString());
            SqlColumn leftCol = join.getLeft().getIdScope().findScopeForVar(v).getColumn();
            SqlColumn rightCol = join.getRight().getIdScope().findScopeForVar(v).getColumn();
            this.out.print("[" + leftCol + "/" + rightCol + "]");
        }
        for (Var v : sqlNode.getNonCoalesceVars()) {
            if (!first) {
                this.out.print(" ");
            }
            first = false;
            this.out.print(v.toString());
            col = join.getIdScope().findScopeForVar(v).getColumn();
            this.out.print("[" + col + "]");
        }
        this.out.ensureStartOfLine();
        this.visitJoin(sqlNode.getJoinNode());
        this.finish();
    }

    public void visit(SqlSlice sqlNode) {
        String startStr = "--";
        String lengthStr = "--";
        if (sqlNode.getStart() >= 0L) {
            startStr = Long.toString(sqlNode.getStart());
        }
        if (sqlNode.getLength() >= 0L) {
            lengthStr = Long.toString(sqlNode.getLength());
        }
        String str2 = String.format("(%s, %s)", startStr, lengthStr);
        this.start(sqlNode, "Slice " + str2, null);
        this.out.incIndent();
        sqlNode.getSubNode().visit(this);
        this.out.decIndent();
        this.finish();
    }

    @Override
    public void visit(SqlSelectBlock sqlNode) {
        this.start(sqlNode, "SqlSelectBlock", sqlNode.getAliasName());
        if (sqlNode.getDistinct()) {
            this.out.println("Distinct");
        }
        this.out.incIndent();
        this.print(sqlNode.getCols());
        this.print(sqlNode.getConditions());
        this.out.decIndent();
        if (sqlNode.getStart() >= 0L || sqlNode.getLength() >= 0L) {
            String startStr = "--";
            String lengthStr = "--";
            if (sqlNode.getStart() >= 0L) {
                startStr = Long.toString(sqlNode.getStart());
            }
            if (sqlNode.getLength() >= 0L) {
                lengthStr = Long.toString(sqlNode.getLength());
            }
            String str2 = String.format("Slice: (%s, %s)", startStr, lengthStr);
            this.out.print(str2);
        }
        sqlNode.getSubNode().visit(this);
        this.finish();
    }

    private void visitJoin(SqlJoin sqlJoin) {
        ++this.depth;
        this.out.ensureStartOfLine();
        this.start(sqlJoin, sqlJoin.getJoinType().printName(), sqlJoin.getAliasName());
        if (sqlJoin.getLeft() == null) {
            this.out.println("<null>");
        } else {
            sqlJoin.getLeft().visit(this);
        }
        this.out.println();
        if (sqlJoin.getRight() == null) {
            this.out.println("<null>");
        } else {
            sqlJoin.getRight().visit(this);
        }
        this.outputConditionList(sqlJoin.getConditions());
        this.finish();
        --this.depth;
    }

    private void addAnnotations(Annotations n) {
        if (!this.withAnnotations) {
            return;
        }
        if (n == null || !n.hasNotes()) {
            return;
        }
        boolean first = true;
        for (String s : n.getNotes()) {
            if (!first) {
                this.out.ensureStartOfLine();
            }
            first = false;
            this.out.pad(40, true);
            this.out.print(" -- ");
            this.out.print(s);
        }
    }

    private void outputConditionList(Collection<SqlExpr> cond) {
        boolean first = true;
        for (SqlExpr c : cond) {
            this.out.println();
            first = false;
            this.out.print("");
            this.out.print("Condition ");
            this.out.print(c.toString());
            this.addAnnotations(c);
            this.out.print("");
        }
    }

    private void start(SqlNode sqlNode, String label, String alias) {
        this.out.print("");
        this.out.print(label);
        if (alias != null) {
            this.out.print("/");
            this.out.print(alias);
        }
        this.addAnnotations(sqlNode);
        this.out.incIndent();
        this.out.println();
    }

    private void finish() {
        this.out.print("");
        this.out.decIndent();
    }
}

