/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.core.sqlnode;

import com.hp.hpl.jena.sdb.core.sqlexpr.SqlColumn;
import com.hp.hpl.jena.sdb.shared.SDBInternalError;

public class ColAlias {
    private SqlColumn column;
    private SqlColumn alias;

    public ColAlias(SqlColumn column, SqlColumn alias) {
        this.column = column;
        this.alias = alias;
    }

    public SqlColumn getColumn() {
        return this.column;
    }

    public SqlColumn getAlias() {
        return this.alias;
    }

    public void check(String requiredName) {
        if (this.getAlias() == null) {
            return;
        }
        if (this.getAlias().getTable() == null) {
            return;
        }
        if (!this.getAlias().getTable().getAliasName().equals(requiredName)) {
            throw new SDBInternalError("Alias name error: " + this.getColumn() + "/" + this.getAlias() + ": required: " + requiredName);
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("(");
        b.append(this.column == null ? "??" : this.column);
        b.append(",");
        b.append(this.alias == null ? "??" : this.alias);
        b.append(")");
        return b.toString();
    }
}

