/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.compiler;

import com.hp.hpl.jena.sdb.core.JoinType;
import com.hp.hpl.jena.sdb.core.SDBRequest;
import com.hp.hpl.jena.sdb.core.ScopeEntry;
import com.hp.hpl.jena.sdb.core.sqlexpr.S_And;
import com.hp.hpl.jena.sdb.core.sqlexpr.S_Equal;
import com.hp.hpl.jena.sdb.core.sqlexpr.S_IsNull;
import com.hp.hpl.jena.sdb.core.sqlexpr.S_Or;
import com.hp.hpl.jena.sdb.core.sqlexpr.SqlColumn;
import com.hp.hpl.jena.sdb.core.sqlexpr.SqlExpr;
import com.hp.hpl.jena.sdb.core.sqlexpr.SqlExprList;
import com.hp.hpl.jena.sdb.core.sqlnode.ColAlias;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlCoalesce;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlJoin;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlNode;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlSelectBlock;
import com.hp.hpl.jena.sdb.core.sqlnode.SqlTable;
import com.hp.hpl.jena.sdb.shared.SDBInternalError;
import com.hp.hpl.jena.sparql.core.Var;
import java.util.Collection;
import java.util.Set;

public class SqlBuilder {
    public static SqlNode distinct(SDBRequest request, SqlNode sqlNode) {
        return SqlSelectBlock.distinct(request, sqlNode);
    }

    public static SqlNode slice(SDBRequest request, SqlNode sqlNode, long start, long length) {
        return SqlSelectBlock.slice(request, sqlNode, start, length);
    }

    public static SqlNode project(SDBRequest request, SqlNode sqlNode, Collection<ColAlias> cols) {
        return SqlSelectBlock.project(request, sqlNode, cols);
    }

    public static SqlNode project(SDBRequest request, SqlNode sqlNode, ColAlias col) {
        return SqlSelectBlock.project(request, sqlNode, col);
    }

    public static SqlNode view(SDBRequest request, SqlNode sqlNode) {
        return SqlSelectBlock.view(request, sqlNode);
    }

    public static SqlNode restrict(SDBRequest request, SqlNode sqlNode, SqlExprList conditions) {
        for (SqlExpr e2 : conditions) {
            sqlNode = SqlSelectBlock.restrict(request, sqlNode, e2);
        }
        return sqlNode;
    }

    public static SqlNode restrict(SDBRequest request, SqlNode sqlNode, SqlExpr expr) {
        if (sqlNode.isInnerJoin()) {
            sqlNode.asInnerJoin().addCondition(expr);
            return sqlNode;
        }
        return SqlSelectBlock.restrict(request, sqlNode, expr);
    }

    public static SqlNode innerJoin(SDBRequest request, SqlNode left, SqlNode right) {
        if (left == null) {
            return right;
        }
        return SqlBuilder.join(request, JoinType.INNER, left, right, null);
    }

    public static SqlNode leftJoin(SDBRequest request, SqlNode left, SqlNode right, SqlExpr expr) {
        if (left == null) {
            throw new SDBInternalError("Attempt to leftJoin to null");
        }
        SqlJoin j = SqlBuilder.join(request, JoinType.LEFT, left, right, null);
        if (expr != null) {
            j.addCondition(expr);
        }
        return j;
    }

    public static SqlNode leftJoinCoalesce(SDBRequest request, String alias, SqlNode left, SqlNode right, Set<Var> coalesceVars) {
        SqlJoin sqlJoin = SqlBuilder.join(request, JoinType.LEFT, left, right, coalesceVars);
        return SqlCoalesce.create(request, alias, sqlJoin, coalesceVars);
    }

    private static SqlJoin join(SDBRequest request, JoinType joinType, SqlNode left, SqlNode right, Set<Var> ignoreVars) {
        SqlExprList conditions = new SqlExprList();
        if (joinType == JoinType.INNER) {
            left = SqlBuilder.extractRestrict(left, conditions);
        }
        right = SqlBuilder.extractRestrict(right, conditions);
        for (Var v : left.getIdScope().getVars()) {
            if (!right.getIdScope().hasColumnForVar(v)) continue;
            ScopeEntry sLeft = left.getIdScope().findScopeForVar(v);
            ScopeEntry sRight = right.getIdScope().findScopeForVar(v);
            SqlExpr c = SqlBuilder.joinCondition(joinType, sLeft, sRight);
            conditions.add(c);
            c.addNote("Join var: " + v);
        }
        SqlJoin join = SqlJoin.create(joinType, left, right);
        join.addConditions(conditions);
        return join;
    }

    private static SqlExpr joinCondition(JoinType joinType, ScopeEntry sLeft, ScopeEntry sRight) {
        SqlExpr c = null;
        SqlColumn leftCol = sLeft.getColumn();
        SqlColumn rightCol = sRight.getColumn();
        if (sLeft.isOptional()) {
            c = SqlBuilder.makeOr(c, new S_IsNull(leftCol));
        }
        if (sRight.isOptional()) {
            c = SqlBuilder.makeOr(c, new S_IsNull(rightCol));
        }
        c = SqlBuilder.makeOr(c, new S_Equal(leftCol, rightCol));
        return c;
    }

    private static SqlExpr makeOr(SqlExpr c, SqlExpr expr) {
        if (c == null) {
            return expr;
        }
        return new S_Or(c, expr);
    }

    private static SqlExpr makeAnd(SqlExpr c, SqlExpr expr) {
        if (c == null) {
            return expr;
        }
        return new S_And(c, expr);
    }

    private static SqlNode extractRestrict(SqlNode sqlNode, SqlExprList conditions) {
        if (sqlNode.isSelectBlock()) {
            SqlSelectBlock block = sqlNode.asSelectBlock();
            if (block.getDistinct()) {
                return sqlNode;
            }
            if (block.hasSlice()) {
                return sqlNode;
            }
            if (block.getSubNode().isTable()) {
                SqlTable t = block.getSubNode().asTable();
                conditions.addAll(block.getConditions());
                return t;
            }
        }
        return sqlNode;
    }
}

