/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sdb.assembler;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.assembler.assemblers.AssemblerBase;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sdb.SDBFactory;
import com.hp.hpl.jena.sdb.StoreDesc;
import com.hp.hpl.jena.sdb.assembler.AssemblerVocab;
import com.hp.hpl.jena.sdb.assembler.DatasetStoreAssembler;
import com.hp.hpl.jena.sdb.assembler.MissingException;
import com.hp.hpl.jena.sparql.util.graph.GraphUtils;

public class SDBModelAssembler
extends AssemblerBase
implements Assembler {
    DatasetStoreAssembler datasetAssem = new DatasetStoreAssembler();

    @Override
    public Model open(Assembler a, Resource root, Mode mode) {
        Resource dataset = GraphUtils.getResourceValue(root, AssemblerVocab.pDataset);
        if (dataset == null) {
            throw new MissingException(root, "No dataset for model or graph");
        }
        StoreDesc storeDesc = this.datasetAssem.openStore(a, dataset, mode);
        String x = GraphUtils.getAsStringValue(root, AssemblerVocab.pNamedGraph1);
        if (x == null) {
            x = GraphUtils.getAsStringValue(root, AssemblerVocab.pNamedGraph2);
        }
        Object g = null;
        if (x == null) {
            return SDBFactory.connectDefaultModel(storeDesc);
        }
        return SDBFactory.connectNamedModel(storeDesc, x);
    }
}

