/*
 * Decompiled with CFR 0.152.
 */
package arq;

import arq.cmdline.ArgDecl;
import arq.cmdline.CmdARQ;
import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.sparql.modify.request.UpdateWriter;
import com.hp.hpl.jena.sparql.util.Utils;
import com.hp.hpl.jena.update.UpdateFactory;
import com.hp.hpl.jena.update.UpdateRequest;
import com.hp.hpl.jena.util.FileUtils;
import java.io.IOException;
import java.util.List;
import java.util.ListIterator;
import org.apache.jena.atlas.io.IndentedLineBuffer;

public class uparse
extends CmdARQ {
    protected static final ArgDecl fileArg = new ArgDecl(true, "file", "update");
    protected static final ArgDecl syntaxArg = new ArgDecl(true, "syntax", "syn");
    List<String> requestFiles = null;
    protected Syntax updateSyntax = Syntax.defaultUpdateSyntax;
    static final String divider = "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -";
    static boolean needDivider = false;

    public static void main(String ... argv) {
        new uparse(argv).mainRun();
    }

    protected uparse(String[] argv) {
        super(argv);
        super.add(fileArg, "--file=FILE", "Update commands to parse");
        super.add(syntaxArg, "--syntax=name", "Update syntax");
    }

    @Override
    protected void processModulesAndArgs() {
        this.requestFiles = this.getValues(fileArg);
        super.processModulesAndArgs();
        if (this.cmdStrictMode) {
            this.updateSyntax = Syntax.syntaxSPARQL_11;
        }
    }

    @Override
    protected String getCommandName() {
        return Utils.className(this);
    }

    @Override
    protected String getSummary() {
        return this.getCommandName() + " --file=<request file> | <update string>";
    }

    @Override
    protected void exec() {
        ListIterator<String> iter = this.requestFiles.listIterator();
        while (iter.hasNext()) {
            String filename = (String)iter.next();
            String x = this.oneFile(filename);
            if (x == null) continue;
            this.execOne(x);
        }
        iter = this.positionals.listIterator();
        while (iter.hasNext()) {
            String x = (String)iter.next();
            x = this.indirect(x);
            this.execOne(x);
        }
    }

    private String oneFile(String filename) {
        uparse.divider();
        try {
            return FileUtils.readWholeFileAsUTF8(filename);
        }
        catch (IOException ex) {
            System.err.println("No such file: " + filename);
            return null;
        }
    }

    private void execOne(String updateString) {
        UpdateRequest req;
        try {
            req = UpdateFactory.create(updateString, this.updateSyntax);
        }
        catch (QueryParseException ex) {
            System.err.print("Parse error: ");
            System.err.println(ex.getMessage());
            return;
        }
        System.out.print(req);
        IndentedLineBuffer w = new IndentedLineBuffer();
        UpdateWriter.output(req, w);
        String updateString2 = w.asString();
        UpdateRequest req2 = null;
        try {
            req2 = UpdateFactory.create(updateString2, this.updateSyntax);
        }
        catch (QueryParseException ex) {
            System.err.println("Can not reparse update after serialization");
            System.err.println(updateString2);
        }
    }

    private static void divider() {
        if (needDivider) {
            System.out.println(divider);
        }
        needDivider = true;
    }
}

