/*
 * Decompiled with CFR 0.152.
 */
package tdb;

import java.util.List;
import jena.cmd.ArgDecl;
import jena.cmd.CmdException;
import org.apache.jena.query.ARQ;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.tdb.TDB;
import org.apache.jena.tdb.TDBLoader;
import org.apache.jena.tdb.store.GraphNonTxnTDB;
import tdb.cmdline.CmdTDB;
import tdb.cmdline.CmdTDBGraph;

public class tdbloader
extends CmdTDBGraph {
    private static final ArgDecl argNoStats = new ArgDecl(false, "nostats");
    private static final ArgDecl argStats = new ArgDecl(true, "stats");
    private boolean showProgress = true;
    private boolean generateStats = true;

    public static void main(String ... argv) {
        CmdTDB.init();
        TDB.setOptimizerWarningFlag(false);
        new tdbloader(argv).mainRun();
    }

    protected tdbloader(String[] argv) {
        super(argv);
        super.add(argNoStats, "--nostats", "Switch off statistics gathering");
        super.add(argStats);
    }

    @Override
    protected void processModulesAndArgs() {
        super.processModulesAndArgs();
    }

    @Override
    protected String getSummary() {
        return this.getCommandName() + " [--desc DATASET | -loc DIR] FILE ...";
    }

    @Override
    protected void exec() {
        List<String> urls;
        if (this.isVerbose()) {
            System.out.println("Java maximum memory: " + Runtime.getRuntime().maxMemory());
            System.out.println(ARQ.getContext());
        }
        if (this.isVerbose()) {
            this.showProgress = true;
        }
        if (this.isQuiet()) {
            this.showProgress = false;
        }
        if (super.contains(argStats)) {
            if (!this.hasValueOfTrue(argStats) && !this.hasValueOfFalse(argStats)) {
                throw new CmdException("Not a boolean value: " + this.getValue(argStats));
            }
            this.generateStats = super.hasValueOfTrue(argStats);
        }
        if (super.contains(argNoStats)) {
            this.generateStats = false;
        }
        if ((urls = this.getPositional()).size() == 0) {
            urls.add("-");
        }
        if (this.graphName == null) {
            this.loadQuads(urls);
            return;
        }
        for (String url : urls) {
            Lang lang = RDFLanguages.filenameToLang(url);
            if (lang == null || !RDFLanguages.isQuads(lang)) continue;
            System.err.println("Warning: Quads format given - only the default graph is loaded into the graph for --graph");
            break;
        }
        this.loadNamedGraph(urls);
    }

    void loadNamedGraph(List<String> urls) {
        GraphNonTxnTDB graph = this.getGraph();
        TDBLoader.load(graph, urls, this.showProgress);
    }

    void loadQuads(List<String> urls) {
        TDBLoader.load(this.getDatasetGraphTDB(), urls, this.showProgress, this.generateStats);
    }
}

