/*
 * Decompiled with CFR 0.152.
 */
package sdb.cmd;

import jena.cmd.ArgDecl;
import jena.cmd.CmdArgModule;
import jena.cmd.CmdGeneral;
import jena.cmd.ModBase;
import org.apache.jena.graph.Graph;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.sdb.SDBFactory;
import org.apache.jena.sdb.Store;

public class ModGraph
extends ModBase {
    private static ArgDecl argDeclGraphName = new ArgDecl(true, "graph");
    private Graph graph = null;
    private String graphName = null;

    @Override
    public void registerWith(CmdGeneral cmdLine) {
        cmdLine.add(argDeclGraphName, "--graph=URI", "Graph name");
    }

    @Override
    public void processArgs(CmdArgModule cmdLine) {
        this.graphName = cmdLine.getValue(argDeclGraphName);
    }

    public String getGraphName() {
        return this.graphName;
    }

    public Graph getGraph(Store store) {
        if (this.graphName == null || this.graphName.equals("default")) {
            return SDBFactory.connectDefaultGraph(store);
        }
        return SDBFactory.connectNamedGraph(store, this.graphName);
    }

    public Model getModel(Store store) {
        if (this.graphName == null || this.graphName.equals("default")) {
            return SDBFactory.connectDefaultModel(store);
        }
        return SDBFactory.connectNamedModel(store, this.graphName);
    }
}

